/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.Nullable;
import org.apache.cxf.jaxrs.ext.xml.XMLInstruction;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.ext.xml.XSISchemaLocation;
import org.apache.cxf.jaxrs.ext.xml.XSLTTransform;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.provider.JAXBAttachmentMarshaller;
import org.apache.cxf.jaxrs.provider.JAXBAttachmentUnmarshaller;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXBUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.DepthExceededStaxException;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.transform.TransformUtils;
import org.w3c.dom.Document;

@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
@Provider
public class JAXBElementProvider<T>
extends AbstractJAXBProvider<T> {
    private static final String XML_PI_START = "<?xml version=\"1.0\" encoding=\"";
    private static final String XML_PI_PROPERTY_RI = "com.sun.xml.bind.xmlHeaders";
    private static final String XML_PI_PROPERTY_RI_INT = "com.sun.xml.internal.bind.xmlHeaders";
    private static final List<String> MARSHALLER_PROPERTIES = Arrays.asList("jaxb.encoding", "jaxb.formatted.output", "jaxb.fragment", "jaxb.noNamespaceSchemaLocation", "jaxb.schemaLocation", "com.sun.xml.bind.namespacePrefixMapper", "com.sun.xml.internal.bind.namespacePrefixMapper", "com.sun.xml.bind.xmlHeaders", "com.sun.xml.internal.bind.xmlHeaders");
    private Map<String, Object> mProperties = Collections.emptyMap();
    private Map<String, String> nsPrefixes = Collections.emptyMap();
    private String xmlResourceOffset = "";
    private String xmlPiPropertyName;

    @Override
    protected boolean objectFactoryOrIndexAvailable(Class<?> type) {
        return !Document.class.isAssignableFrom(type) && super.objectFactoryOrIndexAvailable(type);
    }

    public void setXmlResourceOffset(String value) {
        this.xmlResourceOffset = value;
    }

    public void setNamespacePrefixes(Map<String, String> prefixes) {
        this.nsPrefixes = prefixes;
    }

    protected void setXmlPiProperty(Marshaller ms, String value) throws Exception {
        if (this.xmlPiPropertyName != null) {
            JAXBElementProvider.setMarshallerProp(ms, value, this.xmlPiPropertyName, null);
        } else {
            JAXBElementProvider.setMarshallerProp(ms, value, XML_PI_PROPERTY_RI, XML_PI_PROPERTY_RI_INT);
        }
    }

    @Override
    protected boolean canBeReadAsJaxbElement(Class<?> type) {
        return super.canBeReadAsJaxbElement(type) && type != XMLSource.class && !Source.class.isAssignableFrom(type);
    }

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    @Override
    public void setEnableBuffering(boolean enableBuf) {
        super.setEnableBuffering(enableBuf);
    }

    @Override
    public void setConsumeMediaTypes(List<String> types) {
        super.setConsumeMediaTypes(types);
    }

    @Override
    public void setProduceMediaTypes(List<String> types) {
        super.setProduceMediaTypes(types);
    }

    public void setMarshallerProperties(Map<String, Object> marshallProperties) {
        this.mProperties = marshallProperties;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.mProperties.put("jaxb.schemaLocation", schemaLocation);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T readFrom(Class<T> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        if (this.isPayloadEmpty(headers)) {
            if (AnnotationUtils.getAnnotation(anns, Nullable.class) != null) {
                return null;
            }
            this.reportEmptyContentLength();
        }
        reader = null;
        try {
            isCollection = InjectionUtils.isSupportedCollectionOrArray(type);
            theGenericType /* !! */  = isCollection != false ? InjectionUtils.getActualType(genericType) : type;
            theType = this.getActualType(theGenericType /* !! */ , genericType, anns);
            unmarshaller = this.createUnmarshaller(theType, genericType, isCollection);
            this.addAttachmentUnmarshaller(unmarshaller);
            response = null;
            if (JAXBElement.class.isAssignableFrom(type) || !isCollection && (this.unmarshalAsJaxbElement || this.jaxbElementClassMap != null && this.jaxbElementClassMap.containsKey(theType.getName()))) {
                reader = this.getStreamReader(is, type, mt);
                reader = TransformUtils.createNewReaderIfNeeded(reader, is);
                response = JAXBElement.class.isAssignableFrom(type) && type == theType ? unmarshaller.unmarshal(reader) : unmarshaller.unmarshal(reader, theType);
            } else {
                response = this.doUnmarshal(unmarshaller, type, is, anns, mt);
            }
            if (response instanceof JAXBElement && !JAXBElement.class.isAssignableFrom(type)) {
                response = ((JAXBElement)response).getValue();
            }
            response = isCollection != false ? ((AbstractJAXBProvider.CollectionWrapper)response).getCollectionOrArray(unmarshaller, theType, type, genericType, JAXBUtils.getAdapter(theGenericType /* !! */ , anns)) : JAXBElementProvider.checkAdapter(response, type, anns, false);
            var13_18 = type.cast(response);
            ** try [egrp 1[TRYBLOCK] [0 : 281->289)] { 
        }
        catch (JAXBException e) {
            this.handleJAXBException(e, true);
            return null;
            {
                catch (Throwable var15_20) {
                    throw var15_20;
                }
            }
            catch (DepthExceededStaxException e) {
                throw ExceptionUtils.toWebApplicationException(null, JAXRSUtils.toResponse(413));
                catch (WebApplicationException e) {
                    throw e;
                }
                catch (Exception e) {
                    JAXBElementProvider.LOG.warning(ExceptionUtils.getStackTrace(e));
                    throw ExceptionUtils.toBadRequestException(e, null);
                }
            }
        }
        finally {
            try {
                StaxUtils.close(reader);
            }
            catch (XMLStreamException e) {}
        }
lbl-1000:
        // 1 sources

        {
            StaxUtils.close(reader);
            return var13_18;
        }
lbl26:
        // 1 sources

        catch (XMLStreamException e) {
            // empty catch block
        }
        return var13_18;
    }

    protected Object doUnmarshal(Unmarshaller unmarshaller, Class<?> type, InputStream is, Annotation[] anns, MediaType mt) throws JAXBException {
        XMLStreamReader reader = this.getStreamReader(is, type, mt);
        if (reader != null) {
            try {
                Object object = this.unmarshalFromReader(unmarshaller, reader, anns, mt);
                return object;
            }
            catch (JAXBException e) {
                throw e;
            }
            finally {
                try {
                    StaxUtils.close(reader);
                }
                catch (XMLStreamException e) {}
            }
        }
        return this.unmarshalFromInputStream(unmarshaller, is, anns, mt);
    }

    protected XMLStreamReader getStreamReader(InputStream is, Class<?> type, MediaType mt) {
        XMLInputFactory factory;
        XMLStreamReader reader;
        MessageContext mc = this.getContext();
        XMLStreamReader xMLStreamReader = reader = mc != null ? mc.getContent(XMLStreamReader.class) : null;
        if (reader == null && mc != null && (factory = (XMLInputFactory)mc.get(XMLInputFactory.class.getName())) != null) {
            try {
                reader = factory.createXMLStreamReader(is);
            }
            catch (XMLStreamException e) {
                throw ExceptionUtils.toInternalServerErrorException(new RuntimeException("Can not create XMLStreamReader", e), null);
            }
        }
        if (reader == null && is == null) {
            reader = this.getStreamHandlerFromCurrentMessage(XMLStreamReader.class);
        }
        reader = this.createTransformReaderIfNeeded(reader, is);
        reader = this.createDepthReaderIfNeeded(reader, is);
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            return new AbstractJAXBProvider.JAXBCollectionWrapperReader(TransformUtils.createNewReaderIfNeeded(reader, is));
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unmarshalFromInputStream(Unmarshaller unmarshaller, InputStream is, Annotation[] anns, MediaType mt) throws JAXBException {
        XMLStreamReader xmlReader = null;
        try {
            if (is == null) {
                Reader reader = this.getStreamHandlerFromCurrentMessage(Reader.class);
                if (reader == null) {
                    LOG.severe("No InputStream, Reader, or XMLStreamReader is available");
                    throw ExceptionUtils.toInternalServerErrorException(null, null);
                }
                xmlReader = StaxUtils.createXMLStreamReader(reader);
            } else {
                xmlReader = StaxUtils.createXMLStreamReader(is);
            }
            this.configureReaderRestrictions(xmlReader);
            Object object = unmarshaller.unmarshal(xmlReader);
            return object;
        }
        finally {
            try {
                StaxUtils.close(xmlReader);
            }
            catch (XMLStreamException e) {}
        }
    }

    protected Object unmarshalFromReader(Unmarshaller unmarshaller, XMLStreamReader reader, Annotation[] anns, MediaType mt) throws JAXBException {
        return unmarshaller.unmarshal(reader);
    }

    @Override
    public void writeTo(T obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            String encoding = HttpUtils.getSetEncoding(m, headers, null);
            if (InjectionUtils.isSupportedCollectionOrArray(cls)) {
                this.marshalCollection(cls, obj, genericType, encoding, os, m, anns);
            } else {
                Object actualObject = JAXBElementProvider.checkAdapter(obj, cls, anns, true);
                Class<?> actualClass = obj != actualObject || cls.isInterface() ? actualObject.getClass() : cls;
                this.marshal(actualObject, actualClass, genericType, encoding, os, m, anns);
            }
        }
        catch (JAXBException e) {
            this.handleJAXBException(e, false);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExceptionUtils.toInternalServerErrorException(e, null);
        }
    }

    protected void marshalCollection(Class<?> originalCls, Object collection, Type genericType, String enc, OutputStream os, MediaType m, Annotation[] anns) throws Exception {
        Class actualClass = InjectionUtils.getActualType(genericType);
        actualClass = this.getActualType(actualClass, genericType, anns);
        List<Object> c = originalCls.isArray() ? Arrays.asList((Object[])collection) : (List<Object>)collection;
        Iterator it = c.iterator();
        Object firstObj = it.hasNext() ? (Object)it.next() : null;
        QName qname = null;
        if (firstObj instanceof JAXBElement) {
            JAXBElement el = (JAXBElement)firstObj;
            qname = el.getName();
            actualClass = el.getDeclaredType();
        } else {
            qname = this.getCollectionWrapperQName(actualClass, genericType, firstObj, true);
        }
        if (qname == null) {
            String message = new org.apache.cxf.common.i18n.Message("NO_COLLECTION_ROOT", BUNDLE, new Object[0]).toString();
            throw new WebApplicationException(Response.serverError().entity(message).build());
        }
        StringBuilder pi = new StringBuilder();
        pi.append(XML_PI_START + (enc == null ? "UTF-8" : enc) + "\"?>");
        os.write(pi.toString().getBytes());
        String startTag = null;
        String endTag = null;
        if (qname.getNamespaceURI().length() > 0) {
            String prefix = this.nsPrefixes.get(qname.getNamespaceURI());
            if (prefix == null) {
                prefix = "ns1";
            }
            startTag = "<" + prefix + ":" + qname.getLocalPart() + " xmlns:" + prefix + "=\"" + qname.getNamespaceURI() + "\">";
            endTag = "</" + prefix + ":" + qname.getLocalPart() + ">";
        } else {
            startTag = "<" + qname.getLocalPart() + ">";
            endTag = "</" + qname.getLocalPart() + ">";
        }
        os.write(startTag.getBytes());
        if (firstObj != null) {
            XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(firstObj.getClass(), anns);
            this.marshalCollectionMember(JAXBUtils.useAdapter(firstObj, adapter, true), actualClass, genericType, enc, os, anns, m, qname.getNamespaceURI());
            while (it.hasNext()) {
                this.marshalCollectionMember(JAXBUtils.useAdapter(it.next(), adapter, true), actualClass, genericType, enc, os, anns, m, qname.getNamespaceURI());
            }
        }
        os.write(endTag.getBytes());
    }

    protected void marshalCollectionMember(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, Annotation[] anns, MediaType mt, String ns) throws Exception {
        if (!(obj instanceof JAXBElement)) {
            obj = this.convertToJaxbElementIfNeeded(obj, cls, genericType);
        }
        if (obj instanceof JAXBElement && cls != JAXBElement.class) {
            cls = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(obj, cls, genericType, enc);
        ms.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        if (ns.length() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (!this.nsPrefixes.containsKey(ns)) {
                map.put(ns, "ns1");
            }
            map.putAll(this.nsPrefixes);
            this.setNamespaceMapper(ms, map);
        }
        this.marshal(obj, cls, genericType, enc, os, anns, mt, ms);
    }

    protected void marshal(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, MediaType mt) throws Exception {
        this.marshal(obj, cls, genericType, enc, os, mt, new Annotation[0]);
    }

    protected void marshal(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, MediaType mt, Annotation[] anns) throws Exception {
        if ((obj = this.convertToJaxbElementIfNeeded(obj, cls, genericType)) instanceof JAXBElement && cls != JAXBElement.class) {
            cls = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(obj, cls, genericType, enc);
        if (!this.nsPrefixes.isEmpty()) {
            this.setNamespaceMapper(ms, this.nsPrefixes);
        }
        this.addAttachmentMarshaller(ms);
        this.processXmlAnnotations(ms, mt, anns);
        this.marshal(obj, cls, genericType, enc, os, anns, mt, ms);
    }

    private void processXmlAnnotations(Marshaller ms, MediaType mt, Annotation[] anns) throws Exception {
        if (anns == null) {
            return;
        }
        for (Annotation ann : anns) {
            if (ann.annotationType() == XMLInstruction.class) {
                this.addProcessingInstructions(ms, (XMLInstruction)ann);
                continue;
            }
            if (ann.annotationType() == XSISchemaLocation.class) {
                this.addSchemaLocation(ms, (XSISchemaLocation)ann);
                continue;
            }
            if (ann.annotationType() != XSLTTransform.class) continue;
            this.addXslProcessingInstruction(ms, mt, (XSLTTransform)ann);
        }
    }

    private void addProcessingInstructions(Marshaller ms, XMLInstruction pi) throws Exception {
        String value = pi.value();
        int ind = value.indexOf("href='");
        if (ind > 0) {
            String relRef = value.substring(ind + 6);
            if ((relRef = relRef.substring(0, relRef.length() - 3).trim()).endsWith("'")) {
                relRef = relRef.substring(0, relRef.length() - 1);
            }
            String absRef = this.resolveXMLResourceURI(relRef);
            value = value.substring(0, ind + 6) + absRef + "'?>";
        }
        this.setXmlPiProperty(ms, value);
    }

    private void addXslProcessingInstruction(Marshaller ms, MediaType mt, XSLTTransform ann) throws Exception {
        if (ann.type() == XSLTTransform.TransformType.CLIENT || ann.type() == XSLTTransform.TransformType.BOTH && ann.mediaTypes().length > 0) {
            for (String s : ann.mediaTypes()) {
                if (!mt.isCompatible(JAXRSUtils.toMediaType(s))) continue;
                return;
            }
            String absRef = this.resolveXMLResourceURI(ann.value());
            String xslPi = "<?xml-stylesheet type=\"text/xsl\" href=\"" + absRef + "\"?>";
            this.setXmlPiProperty(ms, xslPi);
        }
    }

    private void addSchemaLocation(Marshaller ms, XSISchemaLocation sl) throws Exception {
        String value = sl.resolve() ? this.resolveXMLResourceURI(sl.value()) : sl.value();
        String propName = !sl.noNamespace() ? "jaxb.schemaLocation" : "jaxb.noNamespaceSchemaLocation";
        ms.setProperty(propName, (Object)value);
    }

    protected String resolveXMLResourceURI(String path) {
        MessageContext mc = this.getContext();
        if (mc != null) {
            String httpBasePath = (String)mc.get("http.base.path");
            UriBuilder builder = null;
            builder = httpBasePath != null ? UriBuilder.fromPath(httpBasePath) : mc.getUriInfo().getBaseUriBuilder();
            return builder.path(path).path(this.xmlResourceOffset).build(new Object[0]).toString();
        }
        return path;
    }

    protected void addAttachmentMarshaller(Marshaller ms) {
        Collection<Attachment> attachments = this.getAttachments(true);
        if (attachments != null) {
            Object value = this.getContext().getContextualProperty("mtom-threshold");
            Integer threshold = value != null ? Integer.valueOf(value.toString()) : 0;
            ms.setAttachmentMarshaller((AttachmentMarshaller)new JAXBAttachmentMarshaller(attachments, threshold));
        }
    }

    protected void addAttachmentUnmarshaller(Unmarshaller um) {
        Collection<Attachment> attachments = this.getAttachments(false);
        if (attachments != null) {
            um.setAttachmentUnmarshaller((AttachmentUnmarshaller)new JAXBAttachmentUnmarshaller(attachments));
        }
    }

    private Collection<Attachment> getAttachments(boolean write) {
        MessageContext mc = this.getContext();
        if (mc != null) {
            String propertyName = write ? "WRITE-" + Message.ATTACHMENTS : Message.ATTACHMENTS;
            return CastUtils.cast((Collection)mc.get(propertyName));
        }
        return null;
    }

    protected void marshal(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, Annotation[] anns, MediaType mt, Marshaller ms) throws Exception {
        XMLStreamWriter writer;
        for (Map.Entry<String, Object> entry : this.mProperties.entrySet()) {
            ms.setProperty(entry.getKey(), entry.getValue());
        }
        MessageContext mc = this.getContext();
        if (mc != null) {
            for (String key : MARSHALLER_PROPERTIES) {
                Object value = mc.get(key);
                if (value == null) continue;
                ms.setProperty(key, value);
            }
        }
        if ((writer = this.getStreamWriter(obj, os, mt)) != null) {
            if (os == null) {
                ms.setProperty("jaxb.fragment", (Object)true);
            } else if (mc != null) {
                if (mc.getContent(XMLStreamWriter.class) != null) {
                    ms.setProperty("jaxb.fragment", (Object)true);
                }
                mc.put(XMLStreamWriter.class.getName(), writer);
            }
            this.marshalToWriter(ms, obj, writer, anns, mt);
            if (mc != null) {
                writer.writeEndDocument();
            }
        } else {
            this.marshalToOutputStream(ms, obj, os, anns, mt);
        }
    }

    protected XMLStreamWriter getStreamWriter(Object obj, OutputStream os, MediaType mt) {
        XMLStreamWriter writer = null;
        MessageContext mc = this.getContext();
        if (mc != null) {
            XMLOutputFactory factory;
            writer = mc.getContent(XMLStreamWriter.class);
            if (writer == null && (factory = (XMLOutputFactory)mc.get(XMLOutputFactory.class.getName())) != null) {
                try {
                    writer = factory.createXMLStreamWriter(os);
                }
                catch (XMLStreamException e) {
                    throw ExceptionUtils.toInternalServerErrorException(new RuntimeException("Cant' create XMLStreamWriter", e), null);
                }
            }
            if (writer == null && this.getEnableStreaming()) {
                writer = StaxUtils.createXMLStreamWriter(os);
            }
        }
        if (writer == null && os == null) {
            writer = this.getStreamHandlerFromCurrentMessage(XMLStreamWriter.class);
        }
        return this.createTransformWriterIfNeeded(writer, os, true);
    }

    protected void marshalToOutputStream(Marshaller ms, Object obj, OutputStream os, Annotation[] anns, MediaType mt) throws Exception {
        if (os == null) {
            Writer writer = this.getStreamHandlerFromCurrentMessage(Writer.class);
            if (writer == null) {
                LOG.severe("No OutputStream, Writer, or XMLStreamWriter is available");
                throw ExceptionUtils.toInternalServerErrorException(null, null);
            }
            ms.marshal(obj, writer);
            writer.flush();
        } else {
            ms.marshal(obj, os);
        }
    }

    protected void marshalToWriter(Marshaller ms, Object obj, XMLStreamWriter writer, Annotation[] anns, MediaType mt) throws Exception {
        ms.marshal(obj, writer);
    }

    public void setXmlPiPropertyName(String xmlPiPropertyName) {
        this.xmlPiPropertyName = xmlPiPropertyName;
    }
}

