/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import com.googlecode.mp4parser.annotations.DoNotParseDetail;
import com.googlecode.mp4parser.boxes.cenc.CencSampleAuxiliaryDataFormat;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSampleEncryptionBox
extends AbstractFullBox {
    protected int algorithmId = -1;
    protected int ivSize = -1;
    protected byte[] kid = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    List<CencSampleAuxiliaryDataFormat> entries = new LinkedList<CencSampleAuxiliaryDataFormat>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    protected AbstractSampleEncryptionBox(String type) {
        super(type);
    }

    public int getOffsetToFirstIV() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        int offset = this.getSize() > 0x100000000L ? 16 : 8;
        offset += this.isOverrideTrackEncryptionBoxParameters() ? 4 + this.kid.length : 0;
        return offset += 4;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        if ((this.getFlags() & 1) > 0) {
            this.algorithmId = IsoTypeReader.readUInt24(content);
            this.ivSize = IsoTypeReader.readUInt8(content);
            this.kid = new byte[16];
            content.get(this.kid);
        }
        long numOfEntries = IsoTypeReader.readUInt32(content);
        ByteBuffer parseEight = content.duplicate();
        ByteBuffer parseSixteen = content.duplicate();
        this.entries = this.parseEntries(parseEight, numOfEntries, 8);
        if (this.entries == null) {
            this.entries = this.parseEntries(parseSixteen, numOfEntries, 16);
            content.position(content.position() + content.remaining() - parseSixteen.remaining());
        } else {
            content.position(content.position() + content.remaining() - parseEight.remaining());
        }
        if (this.entries == null) {
            throw new RuntimeException("Cannot parse SampleEncryptionBox");
        }
    }

    private List<CencSampleAuxiliaryDataFormat> parseEntries(ByteBuffer content, long numOfEntries, int ivSize) {
        LinkedList<CencSampleAuxiliaryDataFormat> _entries = new LinkedList<CencSampleAuxiliaryDataFormat>();
        try {
            long remainingNumOfEntries = numOfEntries;
            while (remainingNumOfEntries-- > 0L) {
                CencSampleAuxiliaryDataFormat e = new CencSampleAuxiliaryDataFormat();
                e.iv = new byte[ivSize];
                content.get(e.iv);
                if ((this.getFlags() & 2) > 0) {
                    int numOfPairs = IsoTypeReader.readUInt16(content);
                    e.pairs = new LinkedList<CencSampleAuxiliaryDataFormat.Pair>();
                    while (numOfPairs-- > 0) {
                        e.pairs.add(e.createPair(IsoTypeReader.readUInt16(content), IsoTypeReader.readUInt32(content)));
                    }
                }
                _entries.add(e);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return null;
        }
        return _entries;
    }

    public List<CencSampleAuxiliaryDataFormat> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries;
    }

    public void setEntries(List<CencSampleAuxiliaryDataFormat> entries) {
        List<CencSampleAuxiliaryDataFormat> list = entries;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)this, list);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    @DoNotParseDetail
    public boolean isSubSampleEncryption() {
        return (this.getFlags() & 2) > 0;
    }

    @DoNotParseDetail
    protected boolean isOverrideTrackEncryptionBoxParameters() {
        return (this.getFlags() & 1) > 0;
    }

    @DoNotParseDetail
    public void setSubSampleEncryption(boolean b) {
        if (b) {
            this.setFlags(this.getFlags() | 2);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFD);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        if (this.isOverrideTrackEncryptionBoxParameters()) {
            IsoTypeWriter.writeUInt24(byteBuffer, this.algorithmId);
            IsoTypeWriter.writeUInt8(byteBuffer, this.ivSize);
            byteBuffer.put(this.kid);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (CencSampleAuxiliaryDataFormat entry : this.entries) {
            if (entry.iv.length != 8 && entry.iv.length != 16) {
                throw new RuntimeException("IV must be either 8 or 16 bytes");
            }
            byteBuffer.put(entry.iv);
            if (!this.isSubSampleEncryption()) continue;
            IsoTypeWriter.writeUInt16(byteBuffer, entry.pairs.size());
            for (CencSampleAuxiliaryDataFormat.Pair pair : entry.pairs) {
                IsoTypeWriter.writeUInt16(byteBuffer, pair.clear);
                IsoTypeWriter.writeUInt32(byteBuffer, pair.encrypted);
            }
        }
    }

    @Override
    protected long getContentSize() {
        long contentSize = 4L;
        if (this.isOverrideTrackEncryptionBoxParameters()) {
            contentSize += 4L;
            contentSize += (long)this.kid.length;
        }
        contentSize += 4L;
        for (CencSampleAuxiliaryDataFormat entry : this.entries) {
            contentSize += (long)entry.getSize();
        }
        return contentSize;
    }

    @Override
    public void getBox(WritableByteChannel os) throws IOException {
        super.getBox(os);
    }

    public boolean equals(Object o) {
        Object object = o;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, object);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSampleEncryptionBox that = (AbstractSampleEncryptionBox)o;
        if (this.algorithmId != that.algorithmId) {
            return false;
        }
        if (this.ivSize != that.ivSize) {
            return false;
        }
        if (this.entries != null ? !this.entries.equals(that.entries) : that.entries != null) {
            return false;
        }
        return Arrays.equals(this.kid, that.kid);
    }

    public int hashCode() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        int result = this.algorithmId;
        result = 31 * result + this.ivSize;
        result = 31 * result + (this.kid != null ? Arrays.hashCode(this.kid) : 0);
        result = 31 * result + (this.entries != null ? this.entries.hashCode() : 0);
        return result;
    }

    public List<Short> getEntrySizes() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        ArrayList<Short> entrySizes = new ArrayList<Short>(this.entries.size());
        for (CencSampleAuxiliaryDataFormat entry : this.entries) {
            short size = (short)entry.iv.length;
            if (this.isSubSampleEncryption()) {
                size = (short)(size + 2);
                size = (short)(size + entry.pairs.size() * 6);
            }
            entrySizes.add(size);
        }
        return entrySizes;
    }

    static {
        AbstractSampleEncryptionBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractSampleEncryptionBox.java", AbstractSampleEncryptionBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOffsetToFirstIV", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 33);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "java.util.List"), 92);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "java.util.List", "entries", "", "void"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "java.lang.Object", "o", "", "boolean"), 164);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 191);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntrySizes", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "java.util.List"), 199);
    }
}

