/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.photoshop.PhotoshopDirectory;

public class PhotoshopReader
implements MetadataReader {
    public void extract(@NotNull BufferReader reader, @NotNull Metadata metadata) {
        PhotoshopDirectory directory = metadata.getOrCreateDirectory(PhotoshopDirectory.class);
        int pos = 0;
        try {
            pos = reader.getString(0, 13).equals("Photoshop 3.0") ? 14 : 0;
        }
        catch (BufferBoundsException e) {
            directory.addError("Unable to read header");
            return;
        }
        while ((long)pos < reader.getLength()) {
            try {
                int tagType = reader.getUInt16(pos += 4);
                int descriptionLength = reader.getUInt16(pos += 2);
                if (descriptionLength < 0 || (long)(descriptionLength + (pos += 2)) > reader.getLength()) {
                    return;
                }
                if ((pos += descriptionLength) % 2 != 0) {
                    ++pos;
                }
                int byteCount = reader.getInt32(pos);
                byte[] tagBytes = reader.getBytes(pos += 4, byteCount);
                if ((pos += byteCount) % 2 != 0) {
                    ++pos;
                }
                directory.setByteArray(tagType, tagBytes);
                if (tagType == 1028) {
                    new IptcReader().extract(new ByteArrayReader(tagBytes), metadata);
                }
                if (tagType < 4000 || tagType > 4999) continue;
                PhotoshopDirectory._tagNameMap.put(tagType, String.format("Plug-in %d Data", tagType - 4000 + 1));
            }
            catch (BufferBoundsException ex) {
                directory.addError(ex.getMessage());
                return;
            }
        }
    }
}

