/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackRunBox
extends AbstractFullBox {
    public static final String TYPE = "trun";
    private int dataOffset;
    private SampleFlags firstSampleFlags;
    private List<Entry> entries = new ArrayList<Entry>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries;
    }

    public void setDataOffset(int dataOffset) {
        int n = dataOffset;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (dataOffset == -1) {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        } else {
            this.setFlags(this.getFlags() | 1);
        }
        this.dataOffset = dataOffset;
    }

    public long[] getSampleCompositionTimeOffsets() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (this.isSampleCompositionTimeOffsetPresent()) {
            long[] result = new long[this.entries.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = this.entries.get(i).getSampleCompositionTimeOffset();
                ++i;
            }
            return result;
        }
        return null;
    }

    public TrackRunBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long size = 8L;
        int flags = this.getFlags();
        if ((flags & 1) == 1) {
            size += 4L;
        }
        if ((flags & 4) == 4) {
            size += 4L;
        }
        long entrySize = 0L;
        if ((flags & 0x100) == 256) {
            entrySize += 4L;
        }
        if ((flags & 0x200) == 512) {
            entrySize += 4L;
        }
        if ((flags & 0x400) == 1024) {
            entrySize += 4L;
        }
        if ((flags & 0x800) == 2048) {
            entrySize += 4L;
        }
        return size += entrySize * (long)this.entries.size();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        int flags = this.getFlags();
        if ((flags & 1) == 1) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.dataOffset);
        }
        if ((flags & 4) == 4) {
            this.firstSampleFlags.getContent(byteBuffer);
        }
        for (Entry entry : this.entries) {
            if ((flags & 0x100) == 256) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.sampleDuration);
            }
            if ((flags & 0x200) == 512) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.sampleSize);
            }
            if ((flags & 0x400) == 1024) {
                entry.sampleFlags.getContent(byteBuffer);
            }
            if ((flags & 0x800) != 2048) continue;
            if (this.getVersion() == 0) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.sampleCompositionTimeOffset);
                continue;
            }
            byteBuffer.putInt((int)entry.sampleCompositionTimeOffset);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        long sampleCount = IsoTypeReader.readUInt32(content);
        this.dataOffset = (this.getFlags() & 1) == 1 ? CastUtils.l2i(IsoTypeReader.readUInt32(content)) : -1;
        if ((this.getFlags() & 4) == 4) {
            this.firstSampleFlags = new SampleFlags(content);
        }
        int i = 0;
        while ((long)i < sampleCount) {
            Entry entry = new Entry();
            if ((this.getFlags() & 0x100) == 256) {
                entry.sampleDuration = IsoTypeReader.readUInt32(content);
            }
            if ((this.getFlags() & 0x200) == 512) {
                entry.sampleSize = IsoTypeReader.readUInt32(content);
            }
            if ((this.getFlags() & 0x400) == 1024) {
                entry.sampleFlags = new SampleFlags(content);
            }
            if ((this.getFlags() & 0x800) == 2048) {
                if (this.getVersion() == 0) {
                    entry.sampleCompositionTimeOffset = IsoTypeReader.readUInt32(content);
                } else {
                    entry.sampleCompositionTimeOffset = content.getInt();
                }
            }
            this.entries.add(entry);
            ++i;
        }
    }

    public long getSampleCount() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries.size();
    }

    public boolean isDataOffsetPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 1) == 1;
    }

    public boolean isFirstSampleFlagsPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 4) == 4;
    }

    public boolean isSampleSizePresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x200) == 512;
    }

    public boolean isSampleDurationPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x100) == 256;
    }

    public boolean isSampleFlagsPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x400) == 1024;
    }

    public boolean isSampleCompositionTimeOffsetPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x800) == 2048;
    }

    public void setDataOffsetPresent(boolean v) {
        boolean bl = v;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        }
    }

    public void setSampleSizePresent(boolean v) {
        boolean bl = v;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v) {
            this.setFlags(this.getFlags() | 0x200);
        } else {
            this.setFlags(this.getFlags() & 0xFFFDFF);
        }
    }

    public void setSampleDurationPresent(boolean v) {
        boolean bl = v;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_12, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v) {
            this.setFlags(this.getFlags() | 0x100);
        } else {
            this.setFlags(this.getFlags() & 0xFFFEFF);
        }
    }

    public void setSampleFlagsPresent(boolean v) {
        boolean bl = v;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_13, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v) {
            this.setFlags(this.getFlags() | 0x400);
        } else {
            this.setFlags(this.getFlags() & 0xFFFBFF);
        }
    }

    public void setSampleCompositionTimeOffsetPresent(boolean v) {
        boolean bl = v;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_14, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v) {
            this.setFlags(this.getFlags() | 0x800);
        } else {
            this.setFlags(this.getFlags() & 0xFFF7FF);
        }
    }

    public int getDataOffset() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_15, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.dataOffset;
    }

    public SampleFlags getFirstSampleFlags() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_16, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.firstSampleFlags;
    }

    public void setFirstSampleFlags(SampleFlags firstSampleFlags) {
        SampleFlags sampleFlags = firstSampleFlags;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_17, (Object)this, (Object)this, sampleFlags);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (firstSampleFlags == null) {
            this.setFlags(this.getFlags() & 0xFFFFFB);
        } else {
            this.setFlags(this.getFlags() | 4);
        }
        this.firstSampleFlags = firstSampleFlags;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_18, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        StringBuilder sb = new StringBuilder();
        sb.append("TrackRunBox");
        sb.append("{sampleCount=").append(this.entries.size());
        sb.append(", dataOffset=").append(this.dataOffset);
        sb.append(", dataOffsetPresent=").append(this.isDataOffsetPresent());
        sb.append(", sampleSizePresent=").append(this.isSampleSizePresent());
        sb.append(", sampleDurationPresent=").append(this.isSampleDurationPresent());
        sb.append(", sampleFlagsPresentPresent=").append(this.isSampleFlagsPresent());
        sb.append(", sampleCompositionTimeOffsetPresent=").append(this.isSampleCompositionTimeOffsetPresent());
        sb.append(", firstSampleFlags=").append(this.firstSampleFlags);
        sb.append('}');
        return sb.toString();
    }

    public void setEntries(List<Entry> entries) {
        List<Entry> list = entries;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_19, (Object)this, (Object)this, list);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    static {
        TrackRunBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TrackRunBox.java", TrackRunBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "java.util.List"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDataOffset", "com.coremedia.iso.boxes.fragment.TrackRunBox", "int", "dataOffset", "", "void"), 120);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDataOffsetPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "boolean", "v", "", "void"), 271);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleSizePresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "boolean", "v", "", "void"), 279);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleDurationPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "boolean", "v", "", "void"), 287);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleFlagsPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "boolean", "v", "", "void"), 296);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleCompositionTimeOffsetPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "boolean", "v", "", "void"), 304);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDataOffset", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "int"), 313);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstSampleFlags", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "com.coremedia.iso.boxes.fragment.SampleFlags"), 317);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFirstSampleFlags", "com.coremedia.iso.boxes.fragment.TrackRunBox", "com.coremedia.iso.boxes.fragment.SampleFlags", "firstSampleFlags", "", "void"), 321);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "java.lang.String"), 331);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "com.coremedia.iso.boxes.fragment.TrackRunBox", "java.util.List", "entries", "", "void"), 346);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleCompositionTimeOffsets", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "[J"), 129);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleCount", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "long"), 242);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDataOffsetPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 246);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isFirstSampleFlagsPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 250);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleSizePresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 255);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleDurationPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 259);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleFlagsPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 263);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleCompositionTimeOffsetPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 267);
    }

    public static class Entry {
        private long sampleDuration;
        private long sampleSize;
        private SampleFlags sampleFlags;
        private long sampleCompositionTimeOffset;

        public Entry() {
        }

        public Entry(long sampleDuration, long sampleSize, SampleFlags sampleFlags, int sampleCompositionTimeOffset) {
            this.sampleDuration = sampleDuration;
            this.sampleSize = sampleSize;
            this.sampleFlags = sampleFlags;
            this.sampleCompositionTimeOffset = sampleCompositionTimeOffset;
        }

        public long getSampleDuration() {
            return this.sampleDuration;
        }

        public long getSampleSize() {
            return this.sampleSize;
        }

        public SampleFlags getSampleFlags() {
            return this.sampleFlags;
        }

        public long getSampleCompositionTimeOffset() {
            return this.sampleCompositionTimeOffset;
        }

        public void setSampleDuration(long sampleDuration) {
            this.sampleDuration = sampleDuration;
        }

        public void setSampleSize(long sampleSize) {
            this.sampleSize = sampleSize;
        }

        public void setSampleFlags(SampleFlags sampleFlags) {
            this.sampleFlags = sampleFlags;
        }

        public void setSampleCompositionTimeOffset(int sampleCompositionTimeOffset) {
            this.sampleCompositionTimeOffset = sampleCompositionTimeOffset;
        }

        public String toString() {
            return "Entry{sampleDuration=" + this.sampleDuration + ", sampleSize=" + this.sampleSize + ", sampleFlags=" + this.sampleFlags + ", sampleCompositionTimeOffset=" + this.sampleCompositionTimeOffset + '}';
        }
    }
}

