/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.hmef.Attachment;
import org.apache.poi.hmef.HMEFMessage;
import org.apache.poi.hmef.attribute.MAPIAttribute;
import org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TNEFParser
implements Parser {
    private static final long serialVersionUID = 4611820730372823452L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.ms-tnef"), MediaType.application((String)"ms-tnef"), MediaType.application((String)"x-tnef"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        EmbeddedDocumentExtractor embeddedExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
        HMEFMessage msg = new HMEFMessage(stream);
        String subject = msg.getSubject();
        if (subject != null && subject.length() > 0) {
            metadata.set(TikaCoreProperties.TITLE, subject);
            metadata.set(TikaCoreProperties.SUBJECT, subject);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        MAPIAttribute attr = msg.getMessageMAPIAttribute(MAPIProperty.RTF_COMPRESSED);
        if (attr != null && attr instanceof MAPIRtfAttribute) {
            MAPIRtfAttribute rtf = (MAPIRtfAttribute)attr;
            this.handleEmbedded("message.rtf", "application/rtf", rtf.getData(), embeddedExtractor, (ContentHandler)xhtml);
        }
        for (Attachment attachment : msg.getAttachments()) {
            String ext;
            Object name = attachment.getLongFilename();
            if (name == null || ((String)name).length() == 0) {
                name = attachment.getFilename();
            }
            if ((name == null || ((String)name).length() == 0) && (ext = attachment.getExtension()) != null) {
                name = "unknown" + ext;
            }
            this.handleEmbedded((String)name, null, attachment.getContents(), embeddedExtractor, (ContentHandler)xhtml);
        }
        xhtml.endDocument();
    }

    private void handleEmbedded(String name, String type, byte[] contents, EmbeddedDocumentExtractor embeddedExtractor, ContentHandler handler) throws IOException, SAXException, TikaException {
        Metadata metadata = new Metadata();
        if (name != null) {
            metadata.set("resourceName", name);
        }
        if (type != null) {
            metadata.set("Content-Type", type);
        }
        if (embeddedExtractor.shouldParseEmbedded(metadata)) {
            embeddedExtractor.parseEmbedded((InputStream)TikaInputStream.get((byte[])contents), (ContentHandler)new EmbeddedContentHandler(handler), metadata, true);
        }
    }
}

