/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.util.AsyncListener;
import org.apache.solr.client.solrj.util.Cancellable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.MDC;

public class LBHttp2SolrClient
extends LBSolrClient {
    private final Http2SolrClient solrClient;

    @Deprecated
    public LBHttp2SolrClient(Http2SolrClient solrClient, String ... baseSolrUrls) {
        super(Arrays.asList(baseSolrUrls));
        this.solrClient = solrClient;
    }

    private LBHttp2SolrClient(Http2SolrClient solrClient, List<String> baseSolrUrls) {
        super(baseSolrUrls);
        this.solrClient = solrClient;
    }

    @Override
    protected SolrClient getClient(String baseUrl) {
        return this.solrClient;
    }

    @Override
    @Deprecated
    public void setParser(ResponseParser parser) {
        super.setParser(parser);
        this.solrClient.setParser(parser);
    }

    @Override
    public ResponseParser getParser() {
        return this.solrClient.getParser();
    }

    @Override
    @Deprecated
    public void setRequestWriter(RequestWriter writer) {
        super.setRequestWriter(writer);
        this.solrClient.setRequestWriter(writer);
    }

    @Override
    public RequestWriter getRequestWriter() {
        return this.solrClient.getRequestWriter();
    }

    public Set<String> getUrlParamNames() {
        return this.solrClient.getUrlParamNames();
    }

    @Deprecated
    public void setQueryParams(Set<String> queryParams) {
        this.solrClient.setUrlParamNames(queryParams);
    }

    @Deprecated
    public void addQueryParams(String queryOnlyParam) {
        HashSet<String> urlParamNames = new HashSet<String>(this.solrClient.getUrlParamNames());
        urlParamNames.add(queryOnlyParam);
        this.solrClient.setUrlParamNames(urlParamNames);
    }

    public Cancellable asyncReq(final LBSolrClient.Req req, final AsyncListener<LBSolrClient.Rsp> asyncListener) {
        final LBSolrClient.Rsp rsp = new LBSolrClient.Rsp();
        final boolean isNonRetryable = req.request instanceof IsUpdateRequest || CommonParams.ADMIN_PATHS.contains(req.request.getPath());
        final LBSolrClient.ServerIterator it = new LBSolrClient.ServerIterator(req, this.zombieServers);
        asyncListener.onStart();
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        final AtomicReference<Cancellable> currentCancellable = new AtomicReference<Cancellable>();
        RetryListener retryListener = new RetryListener(){

            @Override
            public void onSuccess(LBSolrClient.Rsp rsp2) {
                asyncListener.onSuccess(rsp2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Exception e, boolean retryReq) {
                block12: {
                    if (retryReq) {
                        String url;
                        try {
                            url = it.nextOrError(e);
                        }
                        catch (SolrServerException ex) {
                            asyncListener.onFailure(e);
                            return;
                        }
                        try {
                            MDC.put((String)"LBSolrClient.url", (String)url);
                            AtomicBoolean atomicBoolean = cancelled;
                            synchronized (atomicBoolean) {
                                block11: {
                                    if (!cancelled.get()) break block11;
                                    return;
                                }
                                Cancellable cancellable = LBHttp2SolrClient.this.doRequest(url, req, rsp, isNonRetryable, it.isServingZombieServer(), this);
                                currentCancellable.set(cancellable);
                                break block12;
                            }
                        }
                        finally {
                            MDC.remove((String)"LBSolrClient.url");
                        }
                    }
                    asyncListener.onFailure(e);
                }
            }
        };
        try {
            Cancellable cancellable = this.doRequest(it.nextOrError(), req, rsp, isNonRetryable, it.isServingZombieServer(), retryListener);
            currentCancellable.set(cancellable);
        }
        catch (SolrServerException e) {
            asyncListener.onFailure(e);
        }
        return () -> {
            AtomicBoolean atomicBoolean = cancelled;
            synchronized (atomicBoolean) {
                cancelled.set(true);
                if (currentCancellable.get() != null) {
                    ((Cancellable)currentCancellable.get()).cancel();
                }
            }
        };
    }

    private Cancellable doRequest(final String baseUrl, LBSolrClient.Req req, final LBSolrClient.Rsp rsp, final boolean isNonRetryable, final boolean isZombie, final RetryListener listener) {
        rsp.server = baseUrl;
        req.getRequest().setBasePath(baseUrl);
        return ((Http2SolrClient)this.getClient(baseUrl)).asyncRequest(req.getRequest(), null, new AsyncListener<NamedList<Object>>(){

            @Override
            public void onSuccess(NamedList<Object> result) {
                rsp.rsp = result;
                if (isZombie) {
                    LBHttp2SolrClient.this.zombieServers.remove(baseUrl);
                }
                listener.onSuccess(rsp);
            }

            @Override
            public void onFailure(Throwable oe) {
                try {
                    throw (Exception)oe;
                }
                catch (BaseHttpSolrClient.RemoteExecutionException e) {
                    listener.onFailure(e, false);
                }
                catch (SolrException e) {
                    if (!isNonRetryable && LBSolrClient.RETRY_CODES.contains(e.code())) {
                        listener.onFailure(!isZombie ? LBHttp2SolrClient.this.addZombie(baseUrl, e) : e, true);
                    } else {
                        if (isZombie) {
                            LBHttp2SolrClient.this.zombieServers.remove(baseUrl);
                        }
                        listener.onFailure(e, false);
                    }
                }
                catch (SocketException e) {
                    if (!isNonRetryable || e instanceof ConnectException) {
                        listener.onFailure(!isZombie ? LBHttp2SolrClient.this.addZombie(baseUrl, e) : e, true);
                    } else {
                        listener.onFailure(e, false);
                    }
                }
                catch (SocketTimeoutException e) {
                    if (!isNonRetryable) {
                        listener.onFailure(!isZombie ? LBHttp2SolrClient.this.addZombie(baseUrl, e) : e, true);
                    } else {
                        listener.onFailure(e, false);
                    }
                }
                catch (SolrServerException e) {
                    Throwable rootCause = e.getRootCause();
                    if (!isNonRetryable && rootCause instanceof IOException) {
                        listener.onFailure(!isZombie ? LBHttp2SolrClient.this.addZombie(baseUrl, e) : e, true);
                    } else if (isNonRetryable && rootCause instanceof ConnectException) {
                        listener.onFailure(!isZombie ? LBHttp2SolrClient.this.addZombie(baseUrl, e) : e, true);
                    } else {
                        listener.onFailure(e, false);
                    }
                }
                catch (Exception e) {
                    listener.onFailure(new SolrServerException(e), false);
                }
            }
        });
    }

    public static class Builder {
        private final Http2SolrClient http2SolrClient;
        private final String[] baseSolrUrls;
        private long aliveCheckIntervalMillis = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);

        public Builder(Http2SolrClient http2Client, String ... baseSolrUrls) {
            this.http2SolrClient = http2Client;
            this.baseSolrUrls = baseSolrUrls;
        }

        public Builder setAliveCheckInterval(int aliveCheckInterval, TimeUnit unit) {
            if (aliveCheckInterval <= 0) {
                throw new IllegalArgumentException("Alive check interval must be positive, specified value = " + aliveCheckInterval);
            }
            this.aliveCheckIntervalMillis = TimeUnit.MILLISECONDS.convert(aliveCheckInterval, unit);
            return this;
        }

        public LBHttp2SolrClient build() {
            LBHttp2SolrClient solrClient = new LBHttp2SolrClient(this.http2SolrClient, Arrays.asList(this.baseSolrUrls));
            solrClient.aliveCheckIntervalMillis = this.aliveCheckIntervalMillis;
            return solrClient;
        }
    }

    private static interface RetryListener {
        public void onSuccess(LBSolrClient.Rsp var1);

        public void onFailure(Exception var1, boolean var2);
    }
}

