/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStatesOps;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClientClusterStateProvider
implements ClusterStateProvider,
SolrZkClientTimeout.SolrZkClientTimeoutAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    volatile ZkStateReader zkStateReader;
    private boolean closeZkStateReader = true;
    private final String zkHost;
    private final boolean canUseZkACLs;
    private int zkConnectTimeout = SolrZkClientTimeout.DEFAULT_ZK_CONNECT_TIMEOUT;
    private int zkClientTimeout = SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT;
    private volatile boolean isClosed = false;

    public static ZkClientClusterStateProvider from(CloudSolrClient client) {
        if (client.getClusterStateProvider() instanceof ZkClientClusterStateProvider) {
            return (ZkClientClusterStateProvider)client.getClusterStateProvider();
        }
        throw new IllegalArgumentException("This client does not use ZK");
    }

    public ZkClientClusterStateProvider(ZkStateReader zkStateReader) {
        this.zkStateReader = zkStateReader;
        this.closeZkStateReader = false;
        this.zkHost = null;
        this.canUseZkACLs = true;
    }

    public ZkClientClusterStateProvider(Collection<String> zkHosts, String chroot) {
        this(zkHosts, chroot, true);
    }

    public ZkClientClusterStateProvider(Collection<String> zkHosts, String chroot, boolean canUseZkACLs) {
        this.zkHost = ZkClientClusterStateProvider.buildZkHostString(zkHosts, chroot);
        this.canUseZkACLs = canUseZkACLs;
    }

    public ZkClientClusterStateProvider(String zkHost) {
        this.zkHost = zkHost;
        this.canUseZkACLs = true;
    }

    @Deprecated
    public static ClusterState createFromJsonSupportingLegacyConfigName(int version, byte[] bytes, Set<String> liveNodes, String coll, SolrZkClient zkClient) {
        if (bytes == null || bytes.length == 0) {
            return new ClusterState(liveNodes, Collections.emptyMap());
        }
        Map stateMap = (Map)Utils.fromJSON((byte[])bytes);
        Map props = (Map)stateMap.get(coll);
        if (props != null && !props.containsKey("configName")) {
            try {
                String path = "/collections/" + coll;
                byte[] data = zkClient.getData(path, null, null, true);
                if (data != null && data.length > 0) {
                    ZkNodeProps configProp = ZkNodeProps.load((byte[])data);
                    String configName = configProp.getStr("configName");
                    if (configName != null) {
                        props.put("configName", configName);
                        stateMap.put(coll, props);
                    } else {
                        log.warn("configName is null, not found on {}", (Object)path);
                    }
                }
            }
            catch (InterruptedException | KeeperException throwable) {
                // empty catch block
            }
        }
        return ClusterState.createFromCollectionMap((int)version, (Map)stateMap, liveNodes, (DocCollection.PrsSupplier)PerReplicaStatesOps.getZkClientPrsSupplier(zkClient, DocCollection.getCollectionPath((String)coll)));
    }

    public ClusterState.CollectionRef getState(String collection) {
        ClusterState clusterState = this.getZkStateReader().getClusterState();
        if (clusterState != null) {
            return clusterState.getCollectionRef(collection);
        }
        return null;
    }

    public Set<String> getLiveNodes() {
        ClusterState clusterState = this.getZkStateReader().getClusterState();
        if (clusterState != null) {
            return clusterState.getLiveNodes();
        }
        return Collections.emptySet();
    }

    public List<String> resolveAlias(String alias) {
        return this.getZkStateReader().getAliases().resolveAliases(alias);
    }

    public Map<String, String> getAliasProperties(String alias) {
        return this.getZkStateReader().getAliases().getCollectionAliasProperties(alias);
    }

    public String resolveSimpleAlias(String alias) throws IllegalArgumentException {
        return this.getZkStateReader().getAliases().resolveSimpleAlias(alias);
    }

    public Object getClusterProperty(String propertyName) {
        Map<String, Object> props = this.getZkStateReader().getClusterProperties();
        return props.get(propertyName);
    }

    public <T> T getClusterProperty(String propertyName, T def) {
        Map<String, Object> props = this.getZkStateReader().getClusterProperties();
        if (props.containsKey(propertyName)) {
            return (T)props.get(propertyName);
        }
        return def;
    }

    public ClusterState getClusterState() {
        return this.getZkStateReader().getClusterState();
    }

    public Map<String, Object> getClusterProperties() {
        return this.getZkStateReader().getClusterProperties();
    }

    public String getPolicyNameByCollection(String coll) {
        ClusterState.CollectionRef state = this.getState(coll);
        return state == null || state.get() == null ? null : (String)state.get().getProperties().get("policy");
    }

    public void connect() {
        ZkStateReader ignored = this.getZkStateReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZkStateReader getZkStateReader() {
        if (this.isClosed) {
            throw new AlreadyClosedException();
        }
        if (this.zkStateReader == null) {
            ZkClientClusterStateProvider zkClientClusterStateProvider = this;
            synchronized (zkClientClusterStateProvider) {
                if (this.isClosed) {
                    throw new AlreadyClosedException();
                }
                if (this.zkStateReader == null) {
                    ZkStateReader zk = null;
                    try {
                        zk = new ZkStateReader(this.zkHost, this.zkClientTimeout, this.zkConnectTimeout, this.canUseZkACLs);
                        zk.createClusterStateWatchersAndUpdate();
                        log.info("Cluster at {} ready", (Object)this.zkHost);
                        this.zkStateReader = zk;
                    }
                    catch (InterruptedException e) {
                        zk.close();
                        Thread.currentThread().interrupt();
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
                    }
                    catch (KeeperException e) {
                        zk.close();
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
                    }
                    catch (Exception e) {
                        if (zk != null) {
                            zk.close();
                        }
                        throw e;
                    }
                }
            }
        }
        return this.zkStateReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ZkClientClusterStateProvider zkClientClusterStateProvider = this;
        synchronized (zkClientClusterStateProvider) {
            if (!this.isClosed && this.zkStateReader != null) {
                this.isClosed = true;
                ZkStateReader zkToClose = this.zkStateReader;
                this.zkStateReader = null;
                if (this.closeZkStateReader) {
                    zkToClose.close();
                }
            }
        }
    }

    static String buildZkHostString(Collection<String> zkHosts, String chroot) {
        if (zkHosts == null || zkHosts.isEmpty()) {
            throw new IllegalArgumentException("Cannot create CloudSearchClient without valid ZooKeeper host; none specified!");
        }
        StringBuilder zkBuilder = new StringBuilder();
        int lastIndexValue = zkHosts.size() - 1;
        int i = 0;
        for (String zkHost : zkHosts) {
            zkBuilder.append(zkHost);
            if (i < lastIndexValue) {
                zkBuilder.append(",");
            }
            ++i;
        }
        if (chroot != null) {
            if (chroot.startsWith("/")) {
                zkBuilder.append(chroot);
            } else {
                throw new IllegalArgumentException("The chroot must start with a forward slash.");
            }
        }
        String zkHostString = zkBuilder.toString();
        log.debug("Final constructed zkHost string: {}", (Object)zkHostString);
        return zkHostString;
    }

    public String getQuorumHosts() {
        return this.getZkStateReader().getZkClient().getZkServerAddress();
    }

    public String toString() {
        return this.zkHost;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public int getZkConnectTimeout() {
        return this.zkConnectTimeout;
    }

    public void setZkConnectTimeout(int zkConnectTimeout) {
        this.zkConnectTimeout = zkConnectTimeout;
    }

    public int getZkClientTimeout() {
        return this.zkClientTimeout;
    }

    public void setZkClientTimeout(int zkClientTimeout) {
        this.zkClientTimeout = zkClientTimeout;
    }
}

