/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.impl.SolrClientNodeStateProvider;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class NodeValueFetcher {
    public static final String NODE = "node";
    public static final String PORT = "port";
    public static final String HOST = "host";
    public static final String CORES = "cores";
    public static final String SYSPROP = "sysprop.";
    public static final Set<String> tags = Set.of("node", "port", "host", "cores", Tags.FREEDISK.tagName, Tags.HEAPUSAGE.tagName);
    public static final Pattern hostAndPortPattern = Pattern.compile("(?:https?://)?([^:]+):(\\d+)");
    public static final String METRICS_PREFIX = "metrics:";

    private void getRemoteInfo(String solrNode, Set<String> requestedTags, SolrClientNodeStateProvider.RemoteCallCtx ctx) {
        if (!ctx.isNodeAlive(solrNode)) {
            return;
        }
        HashMap<String, Set<Object>> metricsKeyVsTag = new HashMap<String, Set<Object>>();
        for (String tag : requestedTags) {
            if (tag.startsWith(SYSPROP)) {
                metricsKeyVsTag.computeIfAbsent("solr.jvm:system.properties:" + tag.substring(SYSPROP.length()), k -> new HashSet()).add(tag);
                continue;
            }
            if (!tag.startsWith(METRICS_PREFIX)) continue;
            metricsKeyVsTag.computeIfAbsent(tag.substring(METRICS_PREFIX.length()), k -> new HashSet()).add(tag);
        }
        if (!metricsKeyVsTag.isEmpty()) {
            SolrClientNodeStateProvider.fetchReplicaMetrics(solrNode, ctx, metricsKeyVsTag);
        }
        HashSet<String> groups = new HashSet<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        for (Tags t : Tags.values()) {
            if (!requestedTags.contains(t.tagName)) continue;
            groups.add(t.group);
            prefixes.add(t.prefix);
        }
        if (groups.isEmpty() || prefixes.isEmpty()) {
            return;
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("group", new String[]{StrUtils.join(groups, (char)',')});
        params.add("prefix", new String[]{StrUtils.join(prefixes, (char)',')});
        try {
            SimpleSolrResponse rsp = ctx.invokeWithRetry(solrNode, "/admin/metrics", (SolrParams)params);
            NamedList metrics = (NamedList)rsp.getResponse().get("metrics");
            if (metrics != null) {
                for (Tags t : Tags.values()) {
                    ctx.tags.put(t.tagName, t.extractResult(metrics));
                }
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting remote info", (Throwable)e);
        }
    }

    public void getTags(String solrNode, Set<String> requestedTags, SolrClientNodeStateProvider.RemoteCallCtx ctx) {
        try {
            Matcher hostAndPortMatcher;
            if (requestedTags.contains(NODE)) {
                ctx.tags.put(NODE, solrNode);
            }
            if (requestedTags.contains(HOST) && (hostAndPortMatcher = hostAndPortPattern.matcher(solrNode)).find()) {
                ctx.tags.put(HOST, hostAndPortMatcher.group(1));
            }
            if (requestedTags.contains(PORT) && (hostAndPortMatcher = hostAndPortPattern.matcher(solrNode)).find()) {
                ctx.tags.put(PORT, hostAndPortMatcher.group(2));
            }
            this.getRemoteInfo(solrNode, requestedTags, ctx);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public static enum Tags {
        FREEDISK("freedisk", "solr.node", "CONTAINER.fs.usableSpace", "solr.node/CONTAINER.fs.usableSpace"),
        TOTALDISK("totaldisk", "solr.node", "CONTAINER.fs.totalSpace", "solr.node/CONTAINER.fs.totalSpace"),
        CORES("cores", "solr.node", "CONTAINER.cores", null){

            @Override
            public Object extractResult(Object root) {
                NamedList node = (NamedList)Utils.getObjectByPath((Object)root, (boolean)false, (String)"solr.node");
                int count = 0;
                for (String leafCoreMetricName : new String[]{"lazy", "loaded", "unloaded"}) {
                    Number n = (Number)node.get("CONTAINER.cores." + leafCoreMetricName);
                    if (n == null) continue;
                    count += n.intValue();
                }
                return count;
            }
        }
        ,
        SYSLOADAVG("sysLoadAvg", "solr.jvm", "os.systemLoadAverage", "solr.jvm/os.systemLoadAverage"),
        HEAPUSAGE("heapUsage", "solr.jvm", "memory.heap.usage", "solr.jvm/memory.heap.usage");

        public final String group;
        public final String prefix;
        public final String tagName;
        public final String path;

        private Tags(String name, String group, String prefix, String path) {
            this.group = group;
            this.prefix = prefix;
            this.tagName = name;
            this.path = path;
        }

        public Object extractResult(Object root) {
            Object v = Utils.getObjectByPath((Object)root, (boolean)true, (String)this.path);
            return v == null ? null : this.convertVal(v);
        }

        public Object convertVal(Object val) {
            if (val instanceof String) {
                return Double.valueOf((String)val);
            }
            if (val instanceof Number) {
                Number num = (Number)val;
                return num.doubleValue();
            }
            throw new IllegalArgumentException("Unknown type : " + val);
        }
    }
}

