/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.event.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.shiro.event.support.TypedEventListener;

public class SingleArgumentMethodEventListener
implements TypedEventListener {
    private final Object target;
    private final Method method;

    public SingleArgumentMethodEventListener(Object target, Method method) {
        this.target = target;
        this.method = method;
        this.getMethodArgumentType(method);
        this.assertPublicMethod(method);
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    private void assertPublicMethod(Method method) {
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw new IllegalArgumentException("Event handler method [" + String.valueOf(method) + "] must be public.");
        }
    }

    @Override
    public boolean accepts(Object event) {
        return event != null && this.getEventType().isInstance(event);
    }

    @Override
    public Class getEventType() {
        return this.getMethodArgumentType(this.getMethod());
    }

    @Override
    public void onEvent(Object event) {
        Method method = this.getMethod();
        try {
            method.invoke(this.getTarget(), event);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke event handler method [" + String.valueOf(method) + "].", e);
        }
    }

    protected Class getMethodArgumentType(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != 1) {
            String msg = "Event handler methods must accept a single argument.";
            throw new IllegalArgumentException(msg);
        }
        return paramTypes[0];
    }
}

