/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.constant;

import com.google.common.base.Strings;
import lombok.Generated;

public enum QuoteCharacter {
    BACK_QUOTE("`", "`"),
    SINGLE_QUOTE("'", "'"),
    QUOTE("\"", "\""),
    BRACKETS("[", "]"),
    NONE("", "");

    private final String startDelimiter;
    private final String endDelimiter;

    public static QuoteCharacter getQuoteCharacter(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return NONE;
        }
        for (QuoteCharacter each : QuoteCharacter.values()) {
            if (NONE == each || each.startDelimiter.charAt(0) != value.charAt(0)) continue;
            return each;
        }
        return NONE;
    }

    @Generated
    private QuoteCharacter(String startDelimiter, String endDelimiter) {
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
    }

    @Generated
    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    @Generated
    public String getEndDelimiter() {
        return this.endDelimiter;
    }
}

