/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.segment.BindingTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingBindingTableRulesStatement;

public final class DropShardingBindingTableRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingBindingTableRulesStatement, ShardingRuleConfiguration> {
    private Map<String, String> bindingTableRules = Collections.emptyMap();

    public void checkSQLStatement(ShardingSphereDatabase database, DropShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && sqlStatement.isContainsExistClause()) {
            return;
        }
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.bindingTableRules = this.buildBindingTableRule(currentRuleConfig);
        this.checkBindingTableRuleExist(databaseName, sqlStatement, this.bindingTableRules);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig && !currentRuleConfig.getBindingTableGroups().isEmpty() ? 1 : 0) != 0, () -> new RequiredRuleMissedException("Binding", databaseName));
    }

    private Map<String, String> buildBindingTableRule(ShardingRuleConfiguration config) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        config.getBindingTableGroups().forEach(each -> Arrays.stream(each.split(",")).forEach(each1 -> result.put((String)each1, (String)each)));
        return result;
    }

    private void checkBindingTableRuleExist(String databaseName, DropShardingBindingTableRulesStatement sqlStatement, Map<String, String> bindingRelationship) throws DistSQLException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        LinkedList<String> notExistBindingGroups = new LinkedList<String>();
        for (BindingTableRuleSegment each : sqlStatement.getRules()) {
            if (this.isToBeDroppedRuleExists(each, bindingRelationship)) continue;
            notExistBindingGroups.add(each.getTableGroups());
        }
        DistSQLException.predictionThrow((boolean)notExistBindingGroups.isEmpty(), () -> new RequiredRuleMissedException("Binding", databaseName, notExistBindingGroups));
    }

    private boolean isToBeDroppedRuleExists(BindingTableRuleSegment bindingRule, Map<String, String> bindingRelationship) {
        Optional<String> currentBindingRule;
        Optional anyTableInToBeAlteredRule = bindingRule.getBindingTables().stream().findAny();
        if (anyTableInToBeAlteredRule.isPresent() && (currentBindingRule = bindingRelationship.entrySet().stream().filter(each -> ((String)each.getKey()).equalsIgnoreCase((String)anyTableInToBeAlteredRule.get())).map(Map.Entry::getValue).findFirst()).isPresent() && !Strings.isNullOrEmpty((String)currentBindingRule.get())) {
            List currentBindingTables = Splitter.on((String)",").trimResults().splitToList((CharSequence)currentBindingRule.get());
            return bindingRule.getBindingTables().stream().allMatch(each -> this.containsIgnoreCase(currentBindingTables, (String)each));
        }
        return false;
    }

    private boolean containsIgnoreCase(Collection<String> collection, String str) {
        return collection.stream().anyMatch(each -> each.equalsIgnoreCase(str));
    }

    public boolean hasAnyOneToBeDropped(DropShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig)) {
            return false;
        }
        if (this.bindingTableRules.isEmpty()) {
            this.bindingTableRules = this.buildBindingTableRule(currentRuleConfig);
        }
        return !this.getExistedBindingGroups(sqlStatement, this.bindingTableRules).isEmpty();
    }

    private Collection<String> getExistedBindingGroups(DropShardingBindingTableRulesStatement sqlStatement, Map<String, String> bindingTableRules) {
        LinkedList<String> result = new LinkedList<String>();
        if (sqlStatement.getRules().isEmpty()) {
            return new LinkedHashSet<String>(bindingTableRules.values());
        }
        for (BindingTableRuleSegment each : sqlStatement.getRules()) {
            if (!this.isToBeDroppedRuleExists(each, bindingTableRules)) continue;
            result.add(each.getTableGroups());
        }
        return result;
    }

    public boolean updateCurrentRuleConfiguration(DropShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getBindingTableGroups().clear();
        if (!sqlStatement.getRules().isEmpty()) {
            this.getToBeRemoveShardingTable(sqlStatement).forEach(each -> this.bindingTableRules.remove(each));
            currentRuleConfig.getBindingTableGroups().addAll(new LinkedHashSet<String>(this.bindingTableRules.values()));
        }
        return false;
    }

    private Collection<String> getToBeRemoveShardingTable(DropShardingBindingTableRulesStatement sqlStatement) {
        Collection toBeRemoveBindingTables = sqlStatement.getRules().stream().map(BindingTableRuleSegment::getBindingTables).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.bindingTableRules.keySet().stream().filter(each -> this.containsIgnoreCase(toBeRemoveBindingTables, (String)each)).collect(Collectors.toSet());
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return DropShardingBindingTableRulesStatement.class.getName();
    }
}

