/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesUsedKeyGeneratorStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingTableRulesUsedKeyGeneratorQueryResultSet
implements DistSQLResultSet {
    private Iterator<Collection<Object>> data = Collections.emptyIterator();

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        ShowShardingTableRulesUsedKeyGeneratorStatement statement = (ShowShardingTableRulesUsedKeyGeneratorStatement)sqlStatement;
        ArrayList result = new ArrayList();
        Collection shardingTableRules = database.getRuleMetaData().findRuleConfigurations(ShardingRuleConfiguration.class);
        shardingTableRules.forEach(each -> this.requireResult(statement, result, (ShardingRuleConfiguration)each));
        this.data = result.iterator();
    }

    private void requireResult(ShowShardingTableRulesUsedKeyGeneratorStatement statement, List<Collection<Object>> result, ShardingRuleConfiguration shardingRuleConfig) {
        if (!statement.getKeyGeneratorName().isPresent()) {
            return;
        }
        shardingRuleConfig.getTables().forEach(each -> {
            if (null != each.getKeyGenerateStrategy() && ((String)statement.getKeyGeneratorName().get()).equals(each.getKeyGenerateStrategy().getKeyGeneratorName())) {
                result.add(Arrays.asList("table", each.getLogicTable()));
            }
        });
        shardingRuleConfig.getAutoTables().forEach(each -> {
            if (null != each.getKeyGenerateStrategy() && ((String)statement.getKeyGeneratorName().get()).equals(each.getKeyGenerateStrategy().getKeyGeneratorName())) {
                result.add(Arrays.asList("auto_table", each.getLogicTable()));
            }
        });
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("type", "name");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowShardingTableRulesUsedKeyGeneratorStatement.class.getName();
    }
}

