/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPI;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPIFactory;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingListStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShowScalingListQueryResultSet
implements DistSQLResultSet {
    private static final RuleAlteredJobAPI RULE_ALTERED_JOB_API = RuleAlteredJobAPIFactory.getInstance();
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        this.data = RULE_ALTERED_JOB_API.list().stream().map(each -> {
            LinkedList<Object> result = new LinkedList<Object>();
            result.add(each.getJobId());
            result.add(each.getTables());
            result.add(each.getShardingTotalCount());
            result.add(each.isActive() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            result.add(each.getCreateTime());
            result.add(each.getStopTime());
            return result;
        }).collect(Collectors.toList()).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("id", "tables", "sharding_total_count", "active", "create_time", "stop_time");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowScalingListStatement.class.getName();
    }
}

