/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ShorthandProjectionConverter
implements SQLSegmentConverter<ShorthandProjectionSegment, SqlIdentifier> {
    @Override
    public Optional<SqlIdentifier> convertToSQLNode(ShorthandProjectionSegment segment) {
        if (null == segment) {
            return Optional.empty();
        }
        return segment.getOwner().map(optional -> Optional.of(SqlIdentifier.star(Arrays.asList(optional.getIdentifier().getValue(), ""), (SqlParserPos)SqlParserPos.ZERO, (List)ImmutableList.of((Object)SqlParserPos.ZERO)))).orElseGet(() -> Optional.of(SqlIdentifier.star((SqlParserPos)SqlParserPos.ZERO)));
    }

    @Override
    public Optional<ShorthandProjectionSegment> convertToSQLSegment(SqlIdentifier sqlIdentifier) {
        if (null == sqlIdentifier) {
            return Optional.empty();
        }
        ShorthandProjectionSegment result = new ShorthandProjectionSegment(this.getStartIndex((SqlNode)sqlIdentifier), this.getStopIndex((SqlNode)sqlIdentifier));
        if (sqlIdentifier.names.size() > 1) {
            SqlIdentifier owner = sqlIdentifier.getComponent(0);
            result.setOwner(new OwnerSegment(this.getStartIndex((SqlNode)owner), this.getStopIndex((SqlNode)owner), new IdentifierValue((String)sqlIdentifier.names.get(0))));
        }
        return Optional.of(result);
    }
}

