/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.context;

import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.parser.OptimizerParserContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.parser.rule.SQLParserRule;

public final class OptimizerContextFactory {
    public static OptimizerContext create(Map<String, ShardingSphereDatabase> databases, ShardingSphereRuleMetaData globalRuleMetaData) {
        FederationMetaData federationMetaData = new FederationMetaData(databases);
        Map<String, OptimizerParserContext> parserContexts = OptimizerParserContextFactory.create(databases);
        Map<String, OptimizerPlannerContext> plannerContexts = OptimizerPlannerContextFactory.create(federationMetaData);
        SQLParserRule sqlParserRule = globalRuleMetaData.findSingleRule(SQLParserRule.class).orElse(null);
        return new OptimizerContext(sqlParserRule, federationMetaData, parserContexts, plannerContexts);
    }

    @Generated
    private OptimizerContextFactory() {
    }
}

