/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.expr.espresso;

import groovy.lang.Closure;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shardingsphere.infra.expr.hotsopt.HotspotInlineExpressionParser;
import org.apache.shardingsphere.infra.expr.spi.InlineExpressionParser;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;

public final class EspressoInlineExpressionParser
implements InlineExpressionParser {
    private static final String JAVA_CLASSPATH;
    private static final String JAVA_HOME;

    public String handlePlaceHolder(String inlineExpression) {
        try (Context context = this.createContext();){
            String string = this.createInlineExpressionParser(context).invokeMember("handlePlaceHolder", new Object[]{inlineExpression}).asString();
            return string;
        }
    }

    public List<String> splitAndEvaluate(String inlineExpression) {
        try (Context context = this.createContext();){
            List listProjection = (List)this.createInlineExpressionParser(context).invokeMember("splitAndEvaluate", new Object[]{inlineExpression}).as((TypeLiteral)new TypeLiteral<List<String>>(){});
            ArrayList<String> arrayList = new ArrayList<String>(listProjection);
            return arrayList;
        }
    }

    public Closure<?> evaluateClosure(String inlineExpression) {
        try (Context context = this.createContext();){
            Closure closure = (Closure)this.createInlineExpressionParser(context).invokeMember("evaluateClosure", new Object[]{inlineExpression}).as(Closure.class);
            return closure;
        }
    }

    private Value createInlineExpressionParser(Context context) {
        return context.getBindings("java").getMember(HotspotInlineExpressionParser.class.getName()).newInstance(new Object[0]);
    }

    private Context createContext() {
        ShardingSpherePreconditions.checkNotNull((Object)JAVA_HOME, () -> new RuntimeException("Failed to determine the system's environment variable JAVA_HOME!"));
        return Context.newBuilder((String[])new String[0]).allowAllAccess(true).option("java.Properties.org.graalvm.home", JAVA_HOME).option("java.MultiThreaded", Boolean.TRUE.toString()).option("java.Classpath", JAVA_CLASSPATH).build();
    }

    public String getType() {
        return "ESPRESSO";
    }

    static {
        JAVA_HOME = System.getenv("JAVA_HOME");
        URL resource = Thread.currentThread().getContextClassLoader().getResource("espresso-need-libs");
        String dir = null != resource ? resource.getPath() : null;
        JAVA_CLASSPATH = Stream.of("groovy.jar", "guava.jar", "shardingsphere-infra-expr-hotsopt.jar", "shardingsphere-infra-expr-spi.jar", "shardingsphere-infra-util.jar").map(each -> dir + File.separator + each).collect(Collectors.joining(":"));
    }
}

