/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum SystemSchemaBuilderRule {
    MYSQL_INFORMATION_SCHEMA("MySQL", "information_schema", Sets.newHashSet((Object[])new String[]{"columns", "tables", "views"})),
    MYSQL_MYSQL("MySQL", "mysql", Sets.newHashSet((Object[])new String[]{"db"})),
    MYSQL_PERFORMANCE_SCHEMA("MySQL", "performance_schema", Sets.newHashSet((Object[])new String[]{"accounts"})),
    MYSQL_SYS("MySQL", "sys", Sets.newHashSet((Object[])new String[]{"sys"})),
    POSTGRESQL_INFORMATION_SCHEMA("PostgreSQL", "information_schema", Sets.newHashSet((Object[])new String[]{"columns", "tables", "views"})),
    POSTGRESQL_PG_CATALOG("PostgreSQL", "pg_catalog", Sets.newHashSet((Object[])new String[]{"pg_class", "pg_database", "pg_inherits", "pg_tablespace", "pg_trigger"}));

    private static final Map<String, SystemSchemaBuilderRule> SCHEMA_PATH_SYSTEM_SCHEMA_BUILDER_RULE_MAP;
    private final String databaseType;
    private final String schema;
    private final Collection<String> tables;

    public static SystemSchemaBuilderRule valueOf(String databaseType, String schema) {
        String schemaPath = databaseType + "." + schema;
        SystemSchemaBuilderRule result = SCHEMA_PATH_SYSTEM_SCHEMA_BUILDER_RULE_MAP.get(schemaPath);
        if (null == result) {
            throw new IllegalArgumentException(String.format("Can not find builder rule: `%s`", schemaPath));
        }
        return result;
    }

    public static boolean isSystemTable(String schema, String tableName) {
        for (SystemSchemaBuilderRule each : SystemSchemaBuilderRule.values()) {
            if (!each.getSchema().equals(schema) || !each.getTables().contains(tableName)) continue;
            return true;
        }
        return false;
    }

    @Generated
    private SystemSchemaBuilderRule(String databaseType, String schema, Collection<String> tables) {
        this.databaseType = databaseType;
        this.schema = schema;
        this.tables = tables;
    }

    @Generated
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public Collection<String> getTables() {
        return this.tables;
    }

    static {
        SCHEMA_PATH_SYSTEM_SCHEMA_BUILDER_RULE_MAP = new HashMap<String, SystemSchemaBuilderRule>(SystemSchemaBuilderRule.values().length, 1.0f);
        for (SystemSchemaBuilderRule each : SystemSchemaBuilderRule.values()) {
            SCHEMA_PATH_SYSTEM_SCHEMA_BUILDER_RULE_MAP.put(each.getDatabaseType() + "." + each.getSchema(), each);
        }
    }
}

