/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.rule;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class ShardingSphereRuleMetaData {
    private final Collection<RuleConfiguration> configurations;
    private final Collection<ShardingSphereRule> rules;

    public <T extends ShardingSphereRule> Collection<T> findRules(Class<T> clazz) {
        LinkedList<T> result = new LinkedList<T>();
        for (ShardingSphereRule each : this.rules) {
            if (!clazz.isAssignableFrom(each.getClass())) continue;
            result.add(clazz.cast(each));
        }
        return result;
    }

    public <T extends RuleConfiguration> Collection<T> findRuleConfiguration(Class<T> clazz) {
        LinkedList<T> result = new LinkedList<T>();
        for (RuleConfiguration each : this.configurations) {
            if (!clazz.isAssignableFrom(each.getClass())) continue;
            result.add(clazz.cast(each));
        }
        return result;
    }

    public <T extends RuleConfiguration> Optional<T> findSingleRuleConfiguration(Class<T> clazz) {
        Collection<T> foundRuleConfig = this.findRuleConfiguration(clazz);
        return foundRuleConfig.isEmpty() ? Optional.empty() : Optional.of(foundRuleConfig.iterator().next());
    }

    public <T extends ShardingSphereRule> Optional<T> findSingleRule(Class<T> clazz) {
        Collection<T> foundRules = this.findRules(clazz);
        return foundRules.isEmpty() ? Optional.empty() : Optional.of(foundRules.iterator().next());
    }

    @Generated
    public ShardingSphereRuleMetaData(Collection<RuleConfiguration> configurations, Collection<ShardingSphereRule> rules) {
        this.configurations = configurations;
        this.rules = rules;
    }

    @Generated
    public Collection<RuleConfiguration> getConfigurations() {
        return this.configurations;
    }

    @Generated
    public Collection<ShardingSphereRule> getRules() {
        return this.rules;
    }
}

