/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRecognizer;
import org.apache.shardingsphere.infra.metadata.resource.CachedDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.resource.DataSourcesMetaData;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class ShardingSphereMetaData {
    private final String name;
    private final ShardingSphereResource resource;
    private final ShardingSphereRuleMetaData ruleMetaData;
    private final Map<String, ShardingSphereSchema> schemas;

    public static ShardingSphereMetaData create(String databaseName, Map<String, ShardingSphereSchema> schemas, SchemaConfiguration schemaConfig, Collection<ShardingSphereRule> rules, DatabaseType defaultDatabaseType) throws SQLException {
        ShardingSphereResource resource = ShardingSphereMetaData.createResource(schemaConfig.getDataSources(), defaultDatabaseType);
        ShardingSphereRuleMetaData ruleMetaData = new ShardingSphereRuleMetaData(schemaConfig.getRuleConfigurations(), rules);
        return new ShardingSphereMetaData(databaseName, resource, ruleMetaData, schemas);
    }

    private static ShardingSphereResource createResource(Map<String, DataSource> dataSourceMap, DatabaseType defaultDatabaseType) throws SQLException {
        DatabaseType databaseType = dataSourceMap.isEmpty() ? defaultDatabaseType : DatabaseTypeRecognizer.getDatabaseType(dataSourceMap.values());
        DataSourcesMetaData dataSourcesMetaData = new DataSourcesMetaData(databaseType, dataSourceMap);
        CachedDatabaseMetaData cachedDatabaseMetaData = ShardingSphereMetaData.createCachedDatabaseMetaData(dataSourceMap).orElse(null);
        return new ShardingSphereResource(dataSourceMap, dataSourcesMetaData, cachedDatabaseMetaData, databaseType);
    }

    private static Optional<CachedDatabaseMetaData> createCachedDatabaseMetaData(Map<String, DataSource> dataSources) throws SQLException {
        if (dataSources.isEmpty()) {
            return Optional.empty();
        }
        try (Connection connection = dataSources.values().iterator().next().getConnection();){
            Optional<CachedDatabaseMetaData> optional = Optional.of(new CachedDatabaseMetaData(connection.getMetaData()));
            return optional;
        }
    }

    public boolean isComplete() {
        return !this.ruleMetaData.getRules().isEmpty() && !this.resource.getDataSources().isEmpty();
    }

    public boolean hasDataSource() {
        return !this.resource.getDataSources().isEmpty();
    }

    public ShardingSphereSchema getDefaultSchema() {
        return this.schemas.get(this.name);
    }

    public ShardingSphereSchema getSchemaByName(String schemaName) {
        return this.schemas.get(schemaName);
    }

    @Generated
    public ShardingSphereMetaData(String name, ShardingSphereResource resource, ShardingSphereRuleMetaData ruleMetaData, Map<String, ShardingSphereSchema> schemas) {
        this.name = name;
        this.resource = resource;
        this.ruleMetaData = ruleMetaData;
        this.schemas = schemas;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ShardingSphereResource getResource() {
        return this.resource;
    }

    @Generated
    public ShardingSphereRuleMetaData getRuleMetaData() {
        return this.ruleMetaData;
    }

    @Generated
    public Map<String, ShardingSphereSchema> getSchemas() {
        return this.schemas;
    }
}

