/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.props.custom;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;

public final class CustomDataSourceProperties {
    private final Map<String, Object> properties;

    public CustomDataSourceProperties(Map<String, Object> props, Collection<String> standardPropertyKeys, Collection<String> transientFieldNames, Map<String, String> propertySynonyms) {
        this.properties = this.getProperties(props);
        standardPropertyKeys.forEach(this.properties::remove);
        transientFieldNames.forEach(this.properties::remove);
        propertySynonyms.values().forEach(this.properties::remove);
    }

    private Map<String, Object> getProperties(Map<String, Object> props) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(props.size(), 1.0f);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().contains(".")) {
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            String[] complexKeys = entry.getKey().split("\\.");
            if (2 != complexKeys.length) {
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!result.containsKey(complexKeys[0])) {
                result.put(complexKeys[0], new Properties());
            }
            ((Properties)result.get(complexKeys[0])).setProperty(complexKeys[1], entry.getValue().toString());
        }
        return result;
    }

    @Generated
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomDataSourceProperties)) {
            return false;
        }
        CustomDataSourceProperties other = (CustomDataSourceProperties)o;
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }
}

