/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.executor;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.executor.LifecycleExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLifecycleExecutor
implements LifecycleExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLifecycleExecutor.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private volatile boolean running;
    private volatile boolean stopped;
    private volatile long startTimeMillis;

    @Override
    public void start() {
        log.info("start lifecycle executor {}", (Object)super.toString());
        this.running = true;
        this.startTimeMillis = System.currentTimeMillis();
        this.runBlocking();
        this.stop();
    }

    protected abstract void runBlocking();

    @Override
    public final void stop() {
        if (this.stopped) {
            return;
        }
        LocalDateTime startTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.startTimeMillis), ZoneId.systemDefault());
        log.info("stop lifecycle executor {}, startTime={}, cost {} ms", new Object[]{super.toString(), startTime.format(DATE_TIME_FORMATTER), System.currentTimeMillis() - this.startTimeMillis});
        this.doStop();
        this.running = false;
        this.stopped = true;
    }

    protected abstract void doStop();

    @Override
    public final void run() {
        this.start();
    }

    @Generated
    protected boolean isRunning() {
        return this.running;
    }

    @Generated
    protected void setRunning(boolean running) {
        this.running = running;
    }
}

