/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.tdengine.utils;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.seatunnel.connectors.seatunnel.tdengine.exception.TDengineConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.tdengine.exception.TDengineConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDengineUtil {
    private static final Logger log = LoggerFactory.getLogger(TDengineUtil.class);

    public static synchronized void checkDriverExist(String jdbcUrl) {
        try {
            DriverManager.getDriver(jdbcUrl);
        }
        catch (SQLException e) {
            log.warn("no available driver found for this {}, waiting for it to load", (Object)jdbcUrl);
        }
        String driverName = jdbcUrl.startsWith("jdbc:TAOS-RS://") ? "com.taosdata.jdbc.rs.RestfulDriver" : "com.taosdata.jdbc.TSDBDriver";
        try {
            Class<?> clazz = Class.forName(driverName, true, Thread.currentThread().getContextClassLoader());
            Driver driver = (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DriverManager.registerDriver(driver);
        }
        catch (Exception ex) {
            throw new TDengineConnectorException(TDengineConnectorErrorCode.LOAD_DRIVER_FAILED, "Fail to create driver of class " + driverName, ex);
        }
    }
}

