/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.tdengine.source;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.tdengine.config.TDengineSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.tdengine.exception.TDengineConnectorException;
import org.apache.seatunnel.connectors.seatunnel.tdengine.source.TDengineSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.tdengine.utils.TDengineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDengineSourceReader
implements SourceReader<SeaTunnelRow, TDengineSourceSplit> {
    private static final Logger log = LoggerFactory.getLogger(TDengineSourceReader.class);
    private final TDengineSourceConfig config;
    private final Deque<TDengineSourceSplit> sourceSplits;
    private final SourceReader.Context context;
    private Connection conn;
    private volatile boolean noMoreSplit;

    public TDengineSourceReader(TDengineSourceConfig config, SourceReader.Context readerContext) {
        this.config = config;
        this.sourceSplits = new ConcurrentLinkedDeque<TDengineSourceSplit>();
        this.context = readerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector<SeaTunnelRow> collector) throws InterruptedException {
        Object object = collector.getCheckpointLock();
        synchronized (object) {
            log.info("polling new split from queue!");
            TDengineSourceSplit split = this.sourceSplits.poll();
            if (Objects.nonNull(split)) {
                log.info("starting run new split {}, query sql: {}!", (Object)split.splitId(), (Object)split.getQuery());
                try {
                    this.read(split, collector);
                }
                catch (Exception e) {
                    throw new TDengineConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.READER_OPERATION_FAILED, "TDengine split read error", e);
                }
            } else if (this.noMoreSplit && this.sourceSplits.isEmpty()) {
                log.info("Closed the bounded TDengine source");
                this.context.signalNoMoreElement();
            } else {
                Thread.sleep(1000L);
            }
        }
    }

    public void open() {
        String jdbcUrl = this.config.getUrl();
        Properties properties = new Properties();
        properties.put("user", this.config.getUsername());
        properties.put("password", this.config.getPassword());
        try {
            TDengineUtil.checkDriverExist(jdbcUrl);
            this.conn = DriverManager.getConnection(jdbcUrl, properties);
        }
        catch (SQLException e) {
            throw new TDengineConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.READER_OPERATION_FAILED, "get TDengine connection failed:" + jdbcUrl, e);
        }
    }

    public void close() {
        try {
            if (!Objects.isNull(this.conn)) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new TDengineConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.READER_OPERATION_FAILED, "TDengine reader connection close failed", e);
        }
    }

    private void read(TDengineSourceSplit split, Collector<SeaTunnelRow> output) throws Exception {
        try (Statement statement = this.conn.createStatement();
             ResultSet resultSet = statement.executeQuery(split.getQuery());){
            ResultSetMetaData meta = resultSet.getMetaData();
            while (resultSet.next()) {
                Object[] datas = new Object[meta.getColumnCount() + 1];
                datas[0] = split.splitId();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    datas[i] = this.convertDataType(resultSet.getObject(i));
                }
                output.collect((Object)new SeaTunnelRow(datas));
            }
        }
    }

    private Object convertDataType(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        if (Timestamp.class.equals(object.getClass())) {
            return ((Timestamp)object).toLocalDateTime();
        }
        if (byte[].class.equals(object.getClass())) {
            return new String((byte[])object);
        }
        return object;
    }

    public List<TDengineSourceSplit> snapshotState(long checkpointId) {
        return new ArrayList<TDengineSourceSplit>(this.sourceSplits);
    }

    public void addSplits(List<TDengineSourceSplit> splits) {
        this.sourceSplits.addAll(splits);
    }

    public void handleNoMoreSplits() {
        log.info("no more split accepted!");
        this.noMoreSplit = true;
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }
}

