/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.AbstractDriver;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.utils.HttpClientPoolUtil;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSClient;
import com.taosdata.jdbc.ws.WSConnection;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Base64;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class RestfulDriver
extends AbstractDriver {
    private static final String URL_PREFIX = "jdbc:TAOS-RS://";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || url.trim().isEmpty() || url.trim().replaceAll("\\s", "").isEmpty()) {
            throw TSDBError.createSQLException(8978);
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = this.parseURL(url, info);
        String host = props.getProperty("host");
        String port = props.getProperty("port", "6041");
        String database = props.containsKey("dbname") ? props.getProperty("dbname") : null;
        String cloudToken = null;
        if (props.containsKey("token")) {
            cloudToken = props.getProperty("token");
        }
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        if (user == null && cloudToken == null) {
            throw TSDBError.createSQLException(8985);
        }
        if (password == null && cloudToken == null) {
            throw TSDBError.createSQLException(8986);
        }
        try {
            if (user != null) {
                user = URLDecoder.decode(user, StandardCharsets.UTF_8.displayName());
            }
            if (password != null) {
                password = URLDecoder.decode(password, StandardCharsets.UTF_8.displayName());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw TSDBError.createSQLException(8963, "unsupported UTF-8 concoding, user: " + props.getProperty("user") + ", password: " + props.getProperty("password"));
        }
        boolean useSsl = Boolean.parseBoolean(props.getProperty("useSSL", "false"));
        String batchLoad = info.getProperty("batchfetch");
        if (Boolean.parseBoolean(batchLoad)) {
            String protocol = "ws";
            if (useSsl) {
                protocol = "wss";
            }
            String loginUrl = protocol + "://" + props.getProperty("host") + ":" + props.getProperty("port") + "/rest/ws";
            if (null != cloudToken) {
                loginUrl = loginUrl + "?token=" + cloudToken;
            }
            WSClient client = null;
            Transport transport = null;
            int timeout = Integer.parseInt(props.getProperty("messageWaitTimeout", String.valueOf(3000)));
            int maxRequest = Integer.parseInt(props.getProperty("httpPoolSize", "20"));
            int connectTimeout = Integer.parseInt(props.getProperty("httpConnectTimeout", "5000"));
            InFlightRequest inFlightRequest = new InFlightRequest(timeout, maxRequest);
            CountDownLatch latch = new CountDownLatch(1);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            URI urlPath = null;
            try {
                urlPath = new URI(loginUrl);
            }
            catch (URISyntaxException e) {
                throw new SQLException("Websocket url parse error: " + loginUrl, e);
            }
            client = new WSClient(urlPath, user, password, database, inFlightRequest, httpHeaders, latch, maxRequest);
            transport = new Transport(client, inFlightRequest);
            try {
                if (!client.connectBlocking(connectTimeout, TimeUnit.MILLISECONDS)) {
                    this.close(transport);
                    throw new SQLException("can't create connection with server");
                }
                if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
                    this.close(transport);
                    throw new SQLException("auth timeout");
                }
            }
            catch (InterruptedException e) {
                this.close(transport);
                throw new SQLException("create websocket connection has been Interrupted ", e);
            }
            if (!client.isAuth()) {
                this.close(transport);
                throw new SQLException("auth failure");
            }
            TaosGlobalConfig.setCharset(props.getProperty("charset"));
            return new WSConnection(url, props, transport, database);
        }
        HttpClientPoolUtil.init(props);
        String auth = null;
        if (user != null && password != null) {
            auth = Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.UTF_8));
        }
        RestfulConnection conn = new RestfulConnection(host, port, props, database, url, auth, useSsl, cloudToken);
        if (database != null && !database.trim().replaceAll("\\s", "").isEmpty()) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("use " + database);
            }
        }
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw TSDBError.createSQLException(8978);
        }
        return url.trim().length() > 0 && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (this.acceptsURL(url)) {
            info = this.parseURL(url, info);
        }
        return this.getPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private void close(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        try {
            DriverManager.registerDriver(new RestfulDriver());
        }
        catch (SQLException e) {
            throw TSDBError.createRuntimeException(8978, e);
        }
    }
}

