/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.utils.UnsignedDataUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;

public class TSDBResultSetRowData {
    private ArrayList<Object> data;
    private final int colSize;

    public TSDBResultSetRowData(int colSize) {
        this.colSize = colSize;
        this.clear();
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
        }
        if (this.colSize == 0) {
            return;
        }
        this.data = new ArrayList(this.colSize);
        this.data.addAll(Collections.nCopies(this.colSize, null));
    }

    public boolean wasNull(int col) {
        return this.data.get(col - 1) == null;
    }

    public void setBooleanValue(int col, boolean value) {
        this.setBoolean(col - 1, value);
    }

    public void setBoolean(int col, boolean value) {
        this.data.set(col, value);
    }

    public boolean getBoolean(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        switch (nativeType) {
            case 1: {
                return (Boolean)obj;
            }
            case 2: {
                return (Byte)obj == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return UnsignedDataUtils.parseUTinyInt((Byte)obj) == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return (Short)obj == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return UnsignedDataUtils.parseUSmallInt((Short)obj) == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return (Integer)obj == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return UnsignedDataUtils.parseUInteger((Integer)obj) == 1L ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return (Long)obj == 1L ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return UnsignedDataUtils.parseUBigInt((Long)obj).equals(new BigDecimal(0)) ? Boolean.FALSE : Boolean.TRUE;
            }
            case 8: 
            case 10: 
            case 15: {
                String tmp = obj.toString();
                return "1".equals(tmp) || "TRUE".equalsIgnoreCase(tmp);
            }
        }
        return false;
    }

    public void setByteValue(int colIndex, byte value) {
        this.setByte(colIndex - 1, value);
    }

    public void setByte(int col, byte value) {
        this.data.set(col, value);
    }

    public void setShortValue(int colIndex, short value) {
        this.setShort(colIndex - 1, value);
    }

    public void setShort(int col, short value) {
        this.data.set(col, value);
    }

    public void setIntValue(int colIndex, int value) {
        this.setInt(colIndex - 1, value);
    }

    public void setInt(int col, int value) {
        this.data.set(col, value);
    }

    public int getInt(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return 0;
        }
        switch (nativeType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1 : 0;
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 4: {
                return (Integer)obj;
            }
            case 5: 
            case 9: {
                return ((Long)obj).intValue();
            }
            case 8: 
            case 10: 
            case 15: {
                return Integer.parseInt((String)obj);
            }
            case 11: {
                return UnsignedDataUtils.parseUTinyInt((Byte)obj);
            }
            case 12: {
                return UnsignedDataUtils.parseUSmallInt((Short)obj);
            }
            case 13: {
                return Long.valueOf(UnsignedDataUtils.parseUInteger((Integer)obj)).intValue();
            }
            case 14: {
                return UnsignedDataUtils.parseUBigInt((Long)obj).intValue();
            }
            case 6: {
                return ((Float)obj).intValue();
            }
            case 7: {
                return ((Double)obj).intValue();
            }
        }
        return 0;
    }

    public void setLongValue(int colIndex, long value) {
        this.setLong(colIndex - 1, value);
    }

    public void setLong(int col, long value) {
        this.data.set(col, value);
    }

    public long getLong(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return 0L;
        }
        switch (nativeType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1L : 0L;
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 9: {
                return (Long)obj;
            }
            case 8: 
            case 10: 
            case 15: {
                return Long.parseLong((String)obj);
            }
            case 11: {
                return UnsignedDataUtils.parseUTinyInt((Byte)obj);
            }
            case 12: {
                return UnsignedDataUtils.parseUSmallInt((Short)obj);
            }
            case 13: {
                return Long.valueOf(UnsignedDataUtils.parseUInteger((Integer)obj)).intValue();
            }
            case 14: {
                return UnsignedDataUtils.parseUBigInt((Long)obj).intValue();
            }
            case 6: {
                return ((Float)obj).longValue();
            }
            case 7: {
                return ((Double)obj).longValue();
            }
        }
        return 0L;
    }

    public void setFloatValue(int colIndex, float value) {
        this.setFloat(colIndex - 1, value);
    }

    public void setFloat(int col, float value) {
        this.data.set(col, Float.valueOf(value));
    }

    public float getFloat(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return 0.0f;
        }
        switch (nativeType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1.0f : 0.0f;
            }
            case 6: {
                return ((Float)obj).floatValue();
            }
            case 7: {
                return ((Double)obj).floatValue();
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 11: {
                return UnsignedDataUtils.parseUTinyInt((Byte)obj);
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 12: {
                return UnsignedDataUtils.parseUSmallInt((Short)obj);
            }
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 13: {
                return UnsignedDataUtils.parseUInteger((Integer)obj);
            }
            case 5: 
            case 9: {
                return ((Long)obj).longValue();
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)obj;
                if (tmp.compareTo(new BigDecimal(Long.MIN_VALUE)) < 0 || tmp.compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
                    this.throwRangeException(obj.toString(), col, -5);
                }
                return tmp.longValue();
            }
            case 15: {
                return (float)Double.parseDouble((String)obj);
            }
        }
        return 0.0f;
    }

    private void throwRangeException(String valueAsString, int columnIndex, int jdbcType) throws SQLException {
        throw TSDBError.createSQLException(8980, "'" + valueAsString + "' in column '" + columnIndex + "' is outside valid range for the jdbcType " + TSDBConstants.jdbcType2TaosTypeName(jdbcType));
    }

    public void setDoubleValue(int colIndex, double value) {
        this.setDouble(colIndex - 1, value);
    }

    public void setDouble(int col, double value) {
        this.data.set(col, value);
    }

    public double getDouble(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return 0.0;
        }
        switch (nativeType) {
            case 1: {
                return Boolean.TRUE.equals(obj) ? 1.0 : 0.0;
            }
            case 6: {
                return ((Float)obj).floatValue();
            }
            case 7: {
                return (Double)obj;
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 11: {
                return UnsignedDataUtils.parseUTinyInt((Byte)obj);
            }
            case 3: {
                return ((Short)obj).shortValue();
            }
            case 12: {
                return UnsignedDataUtils.parseUSmallInt((Short)obj);
            }
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 13: {
                return UnsignedDataUtils.parseUInteger((Integer)obj);
            }
            case 5: 
            case 9: {
                return ((Long)obj).longValue();
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)obj;
                if (tmp.compareTo(new BigDecimal(Double.MIN_VALUE)) < 0 || tmp.compareTo(new BigDecimal(Double.MAX_VALUE)) > 0) {
                    this.throwRangeException(obj.toString(), col, 93);
                }
                return tmp.floatValue();
            }
            case 15: {
                return Double.parseDouble((String)obj);
            }
        }
        return 0.0;
    }

    public void setStringValue(int colIndex, String value) {
        this.data.set(colIndex - 1, value);
    }

    public void setString(int col, String value) {
        this.data.set(col, value == null ? null : value.getBytes());
    }

    public void setByteArrayValue(int colIndex, byte[] value) {
        this.setByteArray(colIndex - 1, value);
    }

    public void setByteArray(int col, byte[] value) {
        try {
            this.data.set(col, new String(value, TaosGlobalConfig.getCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getString(int col, int nativeType) {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return null;
        }
        switch (nativeType) {
            case 11: {
                byte value = new Byte(String.valueOf(obj));
                if (value >= 0) {
                    return Byte.toString(value);
                }
                return Integer.toString(value & 0xFF);
            }
            case 12: {
                short value = new Short(String.valueOf(obj));
                if (value >= 0) {
                    return Short.toString(value);
                }
                return Integer.toString(value & 0xFFFF);
            }
            case 13: {
                int value = new Integer(String.valueOf(obj));
                if (value >= 0) {
                    return Integer.toString(value);
                }
                return Long.toString((long)value & 0xFFFFFFFFL);
            }
            case 14: {
                long value = new Long(String.valueOf(obj));
                if (value >= 0L) {
                    return Long.toString(value);
                }
                long lowValue = value & Long.MAX_VALUE;
                return BigDecimal.valueOf(lowValue).add(BigDecimal.valueOf(Long.MAX_VALUE)).add(BigDecimal.valueOf(1L)).toString();
            }
            case 8: {
                return new String((byte[])obj);
            }
            case 10: 
            case 15: {
                return (String)obj;
            }
        }
        return String.valueOf(obj);
    }

    public void setTimestampValue(int colIndex, long value) {
        this.setTimestamp(colIndex - 1, value, 0);
    }

    public void setTimestamp(int col, long ts, int precision) {
        int fracNanoseconds;
        long milliseconds;
        switch (precision) {
            case 0: {
                milliseconds = ts;
                fracNanoseconds = (int)(ts * 1000000L % 1000000000L);
                fracNanoseconds = fracNanoseconds < 0 ? 1000000000 + fracNanoseconds : fracNanoseconds;
                break;
            }
            case 1: {
                milliseconds = ts / 1000L;
                fracNanoseconds = (int)(ts * 1000L % 1000000000L);
                if (fracNanoseconds >= 0) break;
                if (milliseconds == 0L) {
                    milliseconds = -1L;
                }
                fracNanoseconds += 1000000000;
                break;
            }
            case 2: {
                milliseconds = ts / 1000000L;
                fracNanoseconds = (int)(ts % 1000000000L);
                if (fracNanoseconds >= 0) break;
                if (milliseconds == 0L) {
                    milliseconds = -1L;
                }
                fracNanoseconds += 1000000000;
                break;
            }
            default: {
                throw new IllegalArgumentException("precision is not valid. precision: " + precision);
            }
        }
        Timestamp tsObj = new Timestamp(milliseconds);
        tsObj.setNanos(fracNanoseconds);
        this.data.set(col, tsObj);
    }

    public void setTimestamp(int col, long ts) {
        if (ts < 10000000000000L) {
            this.data.set(col, new Timestamp(ts));
        } else {
            long epochSec = ts / 1000000L;
            long nanoAdjustment = ts % 1000000L * 1000L;
            Timestamp timestamp = Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
            this.data.set(col, timestamp);
        }
    }

    public Timestamp getTimestamp(int col, int nativeType) {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return null;
        }
        if (nativeType == 5) {
            return new Timestamp((Long)obj);
        }
        return (Timestamp)obj;
    }

    public Object getObject(int col) {
        return this.data.get(col - 1);
    }
}

