/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.socket.source;

import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.socket.config.SocketConfig;
import org.apache.seatunnel.connectors.seatunnel.socket.source.SocketSourceReader;

public class SocketSource
extends AbstractSingleSplitSource<SeaTunnelRow> {
    private final SocketConfig parameter;
    private final CatalogTable catalogTable;
    private JobContext jobContext;

    public SocketSource(ReadonlyConfig pluginConfig) {
        this.parameter = new SocketConfig(pluginConfig);
        SeaTunnelRowType seaTunnelRowType = new SeaTunnelRowType(new String[]{"value"}, new SeaTunnelDataType[]{BasicType.STRING_TYPE});
        this.catalogTable = CatalogTableUtil.getCatalogTable((String)"Socket", (SeaTunnelRowType)seaTunnelRowType);
    }

    public Boundedness getBoundedness() {
        return JobMode.BATCH.equals((Object)this.jobContext.getJobMode()) ? Boundedness.BOUNDED : Boundedness.UNBOUNDED;
    }

    public String getPluginName() {
        return "Socket";
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) throws Exception {
        return new SocketSourceReader(this.parameter, readerContext);
    }
}

