/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.sls.source;

import java.util.List;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.connectors.seatunnel.sls.source.SlsSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.sls.source.SlsSourceReader;
import org.apache.seatunnel.connectors.seatunnel.sls.source.SlsSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.sls.source.SlsSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.sls.state.SlsSourceState;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;

public class SlsSource
implements SeaTunnelSource<SeaTunnelRow, SlsSourceSplit, SlsSourceState>,
SupportParallelism {
    private JobContext jobContext;
    private final SlsSourceConfig slsSourceConfig;

    public SlsSource(ReadonlyConfig readonlyConfig) {
        this.slsSourceConfig = new SlsSourceConfig(readonlyConfig);
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public Boundedness getBoundedness() {
        return JobMode.BATCH.equals((Object)this.jobContext.getJobMode()) ? Boundedness.BOUNDED : Boundedness.UNBOUNDED;
    }

    public SourceReader<SeaTunnelRow, SlsSourceSplit> createReader(SourceReader.Context readContext) throws Exception {
        return new SlsSourceReader(this.slsSourceConfig, readContext);
    }

    public SourceSplitEnumerator<SlsSourceSplit, SlsSourceState> createEnumerator(SourceSplitEnumerator.Context<SlsSourceSplit> enumeratorContext) throws Exception {
        return new SlsSourceSplitEnumerator(this.slsSourceConfig, enumeratorContext);
    }

    public SourceSplitEnumerator<SlsSourceSplit, SlsSourceState> restoreEnumerator(SourceSplitEnumerator.Context<SlsSourceSplit> enumeratorContext, SlsSourceState checkpointState) throws Exception {
        return new SlsSourceSplitEnumerator(this.slsSourceConfig, enumeratorContext, checkpointState);
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Lists.newArrayList((Object[])new CatalogTable[]{this.slsSourceConfig.getCatalogTable()});
    }

    public String getPluginName() {
        return "Sls";
    }
}

