/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.response;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.DataRedundancyType;
import com.aliyun.openservices.log.common.ProjectQuota;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.response.Response;
import java.util.Map;

public class GetProjectResponse
extends Response {
    private static final long serialVersionUID = 1938728647331317823L;
    private String createTime = "";
    private String lastModifyTime = "";
    private String description = "";
    private String status = "";
    private String resourceGroupId = "";
    private String region = "";
    private String owner = "";
    private DataRedundancyType dataRedundancyType;
    private ProjectQuota quota;
    private String transferAcceleration;
    private String location;

    public GetProjectResponse(Map<String, String> headers) {
        super(headers);
    }

    public void FromJsonObject(JSONObject obj) throws LogException {
        try {
            this.description = obj.getString("description");
            this.status = obj.getString("status");
            this.resourceGroupId = obj.getString("resourceGroupId");
            this.region = obj.getString("region");
            this.owner = obj.getString("owner");
            this.dataRedundancyType = DataRedundancyType.parse(obj.getString("dataRedundancyType"));
            this.quota = ProjectQuota.parseFromJSON(obj.getJSONObject("quota"));
            this.transferAcceleration = obj.getString("transferAcceleration");
            this.setCreateTime(obj.getString("createTime"));
            this.setLastModifyTime(obj.getString("lastModifyTime"));
            this.location = obj.getString("location");
        }
        catch (JSONException e) {
            throw new LogException("InvalidErrorResponse", e.getMessage(), this.GetRequestId());
        }
    }

    public String GetProjectDescription() {
        return this.description;
    }

    public String GetProjectStatus() {
        return this.status;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String GetProjectRegion() {
        return this.region;
    }

    public String GetProjectOwner() {
        return this.owner;
    }

    public DataRedundancyType getDataRedundancyType() {
        return this.dataRedundancyType;
    }

    public void setDataRedundancyType(DataRedundancyType dataRedundancyType) {
        this.dataRedundancyType = dataRedundancyType;
    }

    public ProjectQuota getQuota() {
        return this.quota;
    }

    public void setQuota(ProjectQuota quota) {
        this.quota = quota;
    }

    public String getTransferAcceleration() {
        return this.transferAcceleration;
    }

    public void setTransferAcceleration(String transferAcceleration) {
        this.transferAcceleration = transferAcceleration;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getLastModifyTime() {
        return this.lastModifyTime;
    }

    public void setLastModifyTime(String lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

