/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.response;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.QueriedLog;
import com.aliyun.openservices.log.common.QueryResult;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.http.comm.ResponseMessage;
import com.aliyun.openservices.log.response.BasicGetLogsResponse;
import com.aliyun.openservices.log.util.GzipUtils;
import com.aliyun.openservices.log.util.LZ4Encoder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GetLogsResponse
extends BasicGetLogsResponse {
    private static final long serialVersionUID = -7866328557378599379L;
    private boolean mIsCompleted = false;
    private String mMarker = "";
    private String mAggQuery = "";
    private String mWhereQuery = "";
    private boolean mHasSQL = false;
    private long mProcessedRow = 0L;
    private long mElapsedMilliSecond = 0L;
    private long mLimited = 0L;
    private double mCpuSec = 0.0;
    private long mCpuCores = 0L;
    private boolean mIsPhraseQuery = false;
    private boolean mScanAll = false;
    private long mBeginOffset = 0L;
    private long mEndOffset = 0L;
    private long mEndTime = 0L;
    private int mShard = 0;
    private long mScanBytes = 0L;
    private int mQueryMode = 0;
    private ArrayList<String> mKeys;
    private ArrayList<ArrayList<String>> mTerms;
    private List<List<LogContent>> mHighlights;
    private List<String> mColumnTypes;
    private String rawQueryResult;

    public GetLogsResponse(Map<String, String> headers) {
        super(headers);
        this.SetProcessStatus(headers.get("x-log-progress"));
        if (headers.containsKey("x-log-agg-query")) {
            this.setAggQuery(headers.get("x-log-agg-query"));
        }
        if (headers.containsKey("x-log-where-query")) {
            this.setWhereQuery(headers.get("x-log-where-query"));
        }
        if (headers.containsKey("x-log-has-sql")) {
            this.setHasSQL(Boolean.parseBoolean(headers.get("x-log-has-sql")));
        }
        if (headers.containsKey("x-log-processed-rows")) {
            this.setProcessedRow(Long.parseLong(headers.get("x-log-processed-rows")));
        }
        if (headers.containsKey("x-log-elapsed-millisecond")) {
            this.setElapsedMilliSecond(Long.parseLong(headers.get("x-log-elapsed-millisecond")));
        }
        if (headers.containsKey("x-log-cpu-sec")) {
            this.setCpuSec(Double.parseDouble(headers.get("x-log-cpu-sec")));
        }
        if (headers.containsKey("x-log-cpu-cores")) {
            this.setCpuCores(Long.parseLong(headers.get("x-log-cpu-cores")));
        }
        if (headers.containsKey("x-log-query-info")) {
            JSONArray columnTypesAsJson;
            JSONArray highlights;
            JSONObject object = JSONObject.parseObject(headers.get("x-log-query-info"));
            JSONArray keys = object.getJSONArray("keys");
            this.mKeys = new ArrayList();
            if (keys != null) {
                for (int i = 0; i < keys.size(); ++i) {
                    this.mKeys.add(keys.getString(i));
                }
            }
            JSONArray terms = object.getJSONArray("terms");
            this.mTerms = new ArrayList();
            if (terms != null) {
                for (int i = 0; i < terms.size(); ++i) {
                    ArrayList<String> list = new ArrayList<String>();
                    JSONArray term = terms.getJSONArray(i);
                    if (term.size() == 2) {
                        list.add(term.getString(0));
                        list.add(term.getString(1));
                    }
                    this.mTerms.add(list);
                }
            }
            if (object.containsKey("limited")) {
                this.mLimited = Long.parseLong(object.getString("limited"));
            }
            if (object.containsKey("marker")) {
                this.mMarker = object.getString("marker");
            }
            if (object.containsKey("mode")) {
                this.mQueryMode = object.getIntValue("mode");
                if (this.mQueryMode == 1) {
                    this.mIsPhraseQuery = true;
                }
            }
            if (object.containsKey("phraseQueryInfo")) {
                JSONObject phraseQueryInfo = object.getJSONObject("phraseQueryInfo");
                if (phraseQueryInfo.containsKey("scanAll")) {
                    this.mScanAll = Boolean.parseBoolean(phraseQueryInfo.getString("scanAll"));
                }
                if (phraseQueryInfo.containsKey("beginOffset")) {
                    this.mBeginOffset = Long.parseLong(phraseQueryInfo.getString("beginOffset"));
                }
                if (phraseQueryInfo.containsKey("endOffset")) {
                    this.mEndOffset = Long.parseLong(phraseQueryInfo.getString("endOffset"));
                }
                if (phraseQueryInfo.containsKey("endTime")) {
                    this.mEndTime = Long.parseLong(phraseQueryInfo.getString("endTime"));
                }
            }
            if (object.containsKey("shard")) {
                this.mShard = object.getIntValue("shard");
            }
            if (object.containsKey("scanBytes")) {
                this.mScanBytes = object.getLongValue("scanBytes");
            }
            if ((highlights = object.getJSONArray("highlights")) != null) {
                this.mHighlights = new ArrayList<List<LogContent>>(highlights.size());
                for (int i = 0; i < highlights.size(); ++i) {
                    JSONObject jsonObject = highlights.getJSONObject(i);
                    if (jsonObject == null) {
                        this.mHighlights.add(new ArrayList());
                        continue;
                    }
                    ArrayList<LogContent> logContents = new ArrayList<LogContent>(jsonObject.size());
                    Set<String> keySey = jsonObject.keySet();
                    for (String key : keySey) {
                        String value = jsonObject.getString(key);
                        logContents.add(new LogContent(key, value));
                    }
                    this.mHighlights.add(logContents);
                }
            }
            if ((columnTypesAsJson = object.getJSONArray("columnTypes")) != null) {
                this.mColumnTypes = new ArrayList<String>(columnTypesAsJson.size());
                for (int i = 0; i < columnTypesAsJson.size(); ++i) {
                    this.mColumnTypes.add(columnTypesAsJson.getString(i));
                }
            }
        }
    }

    public GetLogsResponse(Map<String, String> headers, QueryResult result) {
        super(headers);
        this.mIsCompleted = result.isCompleted();
        this.setAggQuery(result.getAggQuery());
        this.setWhereQuery(result.getWhereQuery());
        this.setHasSQL(result.isHasSQL());
        this.setProcessedRow(result.getProcessedRows());
        this.setElapsedMilliSecond(result.getElapsedMillisecond());
        this.setCpuCores(result.getCpuCores());
        this.setCpuSec(result.getCpuSec());
        this.mKeys = new ArrayList<String>(result.getKeys());
        List<QueryResult.Term> terms = result.getTerms();
        this.mTerms = new ArrayList();
        for (QueryResult.Term term : terms) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(term.getTerm());
            list.add(term.getKey());
            this.mTerms.add(list);
        }
        this.setmLimited(result.getLimited());
        this.setmMarker(result.getMarker());
        this.mQueryMode = result.getQueryMode();
        this.mIsPhraseQuery = result.isPhraseQuery();
        QueryResult.PhraseQueryInfo queryInfo = result.getPhraseQueryInfo();
        if (queryInfo != null) {
            this.mScanAll = queryInfo.isScanAll();
            this.mBeginOffset = queryInfo.getBeginOffset();
            this.mEndOffset = queryInfo.getEndOffset();
            this.mEndTime = queryInfo.getEndTime();
        }
        this.mShard = result.getShard();
        this.mScanBytes = result.getScanBytes();
        this.mHighlights = result.getHighlights();
        this.mColumnTypes = result.getColumnTypes();
        this.logs = (ArrayList)result.getLogs();
    }

    public GetLogsResponse(Map<String, String> headers, String rawQueryResult) {
        super(headers);
        this.rawQueryResult = rawQueryResult;
    }

    public boolean IsPhraseQuery() {
        return this.mIsPhraseQuery;
    }

    public boolean IsScanAll() {
        return this.mScanAll;
    }

    public long GetBeginOffset() {
        return this.mBeginOffset;
    }

    public long GetEndOffset() {
        return this.mEndOffset;
    }

    public long GetEndTime() {
        return this.mEndTime;
    }

    public int GetShard() {
        return this.mShard;
    }

    public long GetScanBytes() {
        return this.mScanBytes;
    }

    public int GetQueryMode() {
        return this.mQueryMode;
    }

    public String getmMarker() {
        return this.mMarker;
    }

    public void setmMarker(String mMarker) {
        this.mMarker = mMarker;
    }

    public long getmLimited() {
        return this.mLimited;
    }

    public void setmLimited(long mLimited) {
        this.mLimited = mLimited;
    }

    public void setAggQuery(String mAggQuery) {
        this.mAggQuery = mAggQuery;
    }

    public String getAggQuery() {
        return this.mAggQuery;
    }

    public long getElapsedMilliSecond() {
        return this.mElapsedMilliSecond;
    }

    public void setElapsedMilliSecond(long mElapsedMilliSecond) {
        this.mElapsedMilliSecond = mElapsedMilliSecond;
    }

    public void setCpuSec(double mCpuSec) {
        this.mCpuSec = mCpuSec;
    }

    public double getCpuSec() {
        return this.mCpuSec;
    }

    public long getCpuCores() {
        return this.mCpuCores;
    }

    public void setCpuCores(long mCpuCores) {
        this.mCpuCores = mCpuCores;
    }

    public long getProcessedRow() {
        return this.mProcessedRow;
    }

    public void setProcessedRow(long mProcessedRow) {
        this.mProcessedRow = mProcessedRow;
    }

    public boolean isHasSQL() {
        return this.mHasSQL;
    }

    public void setHasSQL(boolean mHasSQL) {
        this.mHasSQL = mHasSQL;
    }

    public String getWhereQuery() {
        return this.mWhereQuery;
    }

    public void setWhereQuery(String mWhereQuery) {
        this.mWhereQuery = mWhereQuery;
    }

    public void SetProcessStatus(String processStatus) {
        this.mIsCompleted = processStatus.equals("Complete");
    }

    public boolean IsCompleted() {
        return this.mIsCompleted;
    }

    public void SetLogs(List<QueriedLog> logs) {
        this.setLogs(logs);
    }

    @Deprecated
    public void AddLog(QueriedLog log) {
        this.addLog(log);
    }

    @Deprecated
    public ArrayList<QueriedLog> GetLogs() {
        return this.logs;
    }

    public int GetCount() {
        return this.logs.size();
    }

    public ArrayList<String> getKeys() {
        return this.mKeys;
    }

    public ArrayList<ArrayList<String>> getTerms() {
        return this.mTerms;
    }

    public List<List<LogContent>> getHighlights() {
        return this.mHighlights;
    }

    public List<String> getColumnTypes() {
        return this.mColumnTypes;
    }

    public String getRawQueryResult() {
        return this.rawQueryResult;
    }

    public static GetLogsResponse deserializeFrom(ResponseMessage response, boolean deserialize) throws LogException {
        byte[] rawData = response.GetRawBody();
        Map<String, String> headers = response.getHeaders();
        String compressType = headers.get("x-log-compresstype");
        String rawSizeStr = headers.get("x-log-bodyrawsize");
        String requestId = response.getRequestId();
        if (compressType != null && rawSizeStr != null) {
            int rawSize = Integer.parseInt(rawSizeStr);
            Consts.CompressType type = Consts.CompressType.fromString(compressType);
            switch (type) {
                case LZ4: {
                    rawData = LZ4Encoder.decompressFromLhLz4Chunk(rawData, rawSize);
                    break;
                }
                case GZIP: {
                    try {
                        rawData = GzipUtils.uncompress(rawData);
                        break;
                    }
                    catch (Exception ex) {
                        throw new LogException("BadResponse", "Fail to uncompress GZIP data", requestId);
                    }
                }
                default: {
                    throw new LogException("BadResponse", "The compress type is not supported: " + compressType, requestId);
                }
            }
        }
        try {
            String data = new String(rawData, "UTF-8");
            if (deserialize) {
                QueryResult result = new QueryResult();
                result.deserializeFrom(data, requestId);
                return new GetLogsResponse(response.getHeaders(), result);
            }
            return new GetLogsResponse(response.getHeaders(), data);
        }
        catch (UnsupportedEncodingException ex) {
            throw new LogException("EncodingException", ex.getMessage(), response.getRequestId());
        }
    }
}

