/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.response;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.Histogram;
import com.aliyun.openservices.log.response.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GetHistogramsResponse
extends Response {
    private static final long serialVersionUID = 5169979404935069850L;
    private boolean mIsCompleted = false;
    private long mCount = 0L;
    private long mScanBytes = 0L;
    private ArrayList<Histogram> mHistogram = new ArrayList();

    public GetHistogramsResponse(Map<String, String> headers) {
        super(headers);
        this.SetProcessStatus(headers.get("x-log-progress"));
        if (headers.containsKey("x-log-scanbytes")) {
            this.mScanBytes = Long.parseLong(headers.get("x-log-scanbytes"));
        }
    }

    public long GetTotalCount() {
        return this.mCount;
    }

    public long GetScanBytes() {
        return this.mScanBytes;
    }

    public void SetProcessStatus(String processStatus) {
        this.mIsCompleted = processStatus.equals("Complete");
    }

    public boolean IsCompleted() {
        return this.mIsCompleted;
    }

    public void AddHistogram(Histogram histogram) {
        this.addHistogram(histogram);
    }

    public void addHistogram(Histogram histogram) {
        this.mHistogram.add(histogram);
        this.mCount += histogram.GetCount();
    }

    public void SetHistograms(List<Histogram> histograms) {
        this.mHistogram = new ArrayList<Histogram>(histograms);
    }

    public ArrayList<Histogram> GetHistograms() {
        return this.mHistogram;
    }

    public void fromJSON(JSONArray items) {
        this.mHistogram.clear();
        this.mCount = 0L;
        if (items == null) {
            return;
        }
        try {
            for (int i = 0; i < items.size(); ++i) {
                JSONObject item = items.getJSONObject(i);
                if (item == null) continue;
                Histogram histogram = new Histogram(item.getIntValue("from"), item.getIntValue("to"), item.getLong("count"), item.getString("progress"));
                this.addHistogram(histogram);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

