/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.request;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.request.Request;

public class GetLogsRequest
extends Request {
    private static final long serialVersionUID = -484272901258629068L;
    private String mLogStore;
    private int from;
    private int to;
    private String topic;
    private String query;
    private Long offset;
    private Long line;
    private Boolean reverse;
    private Boolean powerSql;
    private Boolean forward;
    private Integer shard;
    private String session;
    private Boolean accurate;
    private Boolean needHighlight;
    private int fromNsPart;
    private int toNsPart;
    private Consts.CompressType compressType = Consts.CompressType.LZ4;

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query) {
        super(project);
        this.mLogStore = logStore;
        this.SetTopic(topic);
        this.SetQuery(query);
        this.SetFromTime(from);
        this.SetToTime(to);
    }

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query, long offset, long line, boolean reverse) {
        this(project, logStore, from, to, topic, query);
        this.SetOffset(offset);
        this.SetLine(line);
        this.SetReverse(reverse);
    }

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query, long offset, long line, boolean reverse, boolean powerSql) {
        this(project, logStore, from, to, topic, query);
        this.SetOffset(offset);
        this.SetLine(line);
        this.SetReverse(reverse);
        this.SetPowerSql(powerSql);
    }

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query, long offset, long line, boolean reverse, boolean powerSql, boolean forward) {
        this(project, logStore, from, to, topic, query);
        this.SetOffset(offset);
        this.SetLine(line);
        this.SetReverse(reverse);
        this.SetPowerSql(powerSql);
        this.SetForward(forward);
    }

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query, long offset, long line, boolean reverse, int shard) {
        this(project, logStore, from, to, topic, query, offset, line, reverse);
        this.SetShard(shard);
    }

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query, long offset, long line, boolean reverse, boolean forward, String session) {
        this(project, logStore, from, to, topic, query, offset, line, reverse);
        this.SetForward(forward);
        this.SetSession(session);
    }

    public void SetLogStore(String logStore) {
        this.mLogStore = logStore;
    }

    public String GetLogStore() {
        return this.mLogStore;
    }

    public void SetTopic(String topic) {
        this.topic = topic == null ? "" : topic;
    }

    public String GetTopic() {
        return this.topic;
    }

    public void SetQuery(String query) {
        this.query = query == null ? "" : query;
    }

    public String GetQuery() {
        return this.query;
    }

    public void SetFromTime(int from) {
        this.from = from;
    }

    public int GetFromTime() {
        return this.from;
    }

    public void SetToTime(int to) {
        this.to = to;
    }

    public int GetToTime() {
        return this.to;
    }

    public void SetOffset(long offset) {
        this.offset = offset;
    }

    public long GetOffset() {
        return this.offset != null ? this.offset : 0L;
    }

    public void SetLine(long line) {
        this.line = line;
    }

    public long GetLine() {
        return this.line != null ? this.line : 0L;
    }

    public void SetReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public boolean GetReverse() {
        return this.reverse != null && this.reverse != false;
    }

    public void SetPowerSql(boolean powerSql) {
        this.powerSql = powerSql;
    }

    public void SetShard(int shard) {
        this.shard = shard;
    }

    public void SetSession(String session) {
        if (session != null) {
            this.session = session;
        }
    }

    public boolean GetPowerSql() {
        return this.powerSql != null && this.powerSql != false;
    }

    public void SetForward(boolean forward) {
        this.forward = forward;
    }

    public boolean GetForward() {
        return this.forward != null && this.forward != false;
    }

    public void SetAccurate(boolean accurate) {
        this.accurate = accurate;
    }

    public boolean GetAccurate() {
        return this.accurate != null && this.accurate != false;
    }

    public Consts.CompressType getCompressType() {
        return this.compressType;
    }

    public void setCompressType(Consts.CompressType compressType) {
        this.compressType = compressType;
    }

    public void SetNeedHighlight(boolean needHighlight) {
        this.needHighlight = needHighlight;
    }

    public boolean GetNeedHighlight() {
        return this.needHighlight != null && this.needHighlight != false;
    }

    public void SetFromNsPart(int fromNsPart) {
        this.fromNsPart = fromNsPart;
    }

    public int GetFromNsPart() {
        return this.fromNsPart;
    }

    public void SetToNsPart(int toNsPart) {
        this.toNsPart = toNsPart;
    }

    public int GetToNsPart() {
        return this.toNsPart;
    }

    private static void addParameterIfNotNull(JSONObject dest, String key, Object value) {
        if (value != null) {
            dest.put(key, value);
        }
    }

    public String getRequestBody() {
        JSONObject body = new JSONObject();
        body.put("from", (Object)this.from);
        body.put("to", (Object)this.to);
        body.put("topic", (Object)this.topic);
        body.put("query", (Object)this.query);
        GetLogsRequest.addParameterIfNotNull(body, "line", this.line);
        GetLogsRequest.addParameterIfNotNull(body, "offset", this.offset);
        GetLogsRequest.addParameterIfNotNull(body, "reverse", this.reverse);
        GetLogsRequest.addParameterIfNotNull(body, "powerSql", this.powerSql);
        GetLogsRequest.addParameterIfNotNull(body, "session", this.session);
        GetLogsRequest.addParameterIfNotNull(body, "shard", this.shard);
        GetLogsRequest.addParameterIfNotNull(body, "accurate", this.accurate);
        GetLogsRequest.addParameterIfNotNull(body, "forward", this.forward);
        GetLogsRequest.addParameterIfNotNull(body, "highlight", this.needHighlight);
        GetLogsRequest.addParameterIfNotNull(body, "fromNs", this.fromNsPart);
        GetLogsRequest.addParameterIfNotNull(body, "toNs", this.toNsPart);
        return body.toString();
    }
}

