/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class HttpUtil {
    public static final String DEFAULT_CHARSET_NAME = "utf-8";
    private static final String ISO_8859_1_CHARSET = "iso-8859-1";
    private static final String UTF8_CHARSET = "utf-8";

    public static String urlEncode(String value, String encoding) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, encoding);
            return encoded.replace("+", "%20").replace("*", "%2A").replace("~", "%7E").replace("/", "%2F");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("FailedToEncodeUri", e);
        }
    }

    public static String percentEncode(String value) {
        try {
            return value != null ? URLEncoder.encode(value, "utf-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String trim(String value) {
        return value != null ? value.trim() : "";
    }

    public static String paramToQueryString(Map<String, String> params, String charset) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder paramString = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> p : params.entrySet()) {
            String key = p.getKey();
            String value = p.getValue();
            if (!first) {
                paramString.append("&");
            }
            paramString.append(HttpUtil.urlEncode(key, charset));
            if (value != null) {
                paramString.append("=").append(HttpUtil.urlEncode(value, charset));
            }
            first = false;
        }
        return paramString.toString();
    }

    public static void convertHeaderCharsetFromIso88591(Map<String, String> headers) {
        HttpUtil.convertHeaderCharset(headers, ISO_8859_1_CHARSET, "utf-8");
    }

    public static void convertHeaderCharsetToIso88591(Map<String, String> headers) {
        HttpUtil.convertHeaderCharset(headers, "utf-8", ISO_8859_1_CHARSET);
    }

    private static void convertHeaderCharset(Map<String, String> headers, String fromCharset, String toCharset) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (header.getValue() == null) continue;
            try {
                header.setValue(new String(header.getValue().getBytes(fromCharset), toCharset));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Invalid charset name: " + e.getMessage(), e);
            }
        }
    }
}

