/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common.auth;

import com.aliyun.openservices.log.common.auth.Credentials;

public class TemporaryCredentials
implements Credentials {
    public static final double DEFAULT_EXPIRED_FACTOR = 0.8;
    protected String accessKeyId;
    protected String accessKeySecret;
    protected String securityToken;
    protected long expiration;
    protected long lastUpdated;
    protected double expiredFactor = 0.8;

    public TemporaryCredentials(String accessKeyId, String accessKeySecret, String securityToken, long expiration, long lastUpdated) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.expiration = expiration;
        this.lastUpdated = lastUpdated;
    }

    public boolean shouldRefresh() {
        long now = System.currentTimeMillis();
        return (double)(now - this.lastUpdated) >= (double)(this.expiration - this.lastUpdated) * this.expiredFactor;
    }

    public TemporaryCredentials withExpiredFactor(double expiredFactor) {
        this.expiredFactor = expiredFactor;
        return this;
    }

    @Override
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    @Override
    public String getSecurityToken() {
        return this.securityToken;
    }

    @Override
    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    @Override
    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    @Override
    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }
}

