/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.OssShipperStorageDetail;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;

public class OssShipperJsonStorageDetail
extends OssShipperStorageDetail
implements Serializable {
    private static final long serialVersionUID = -7191203366698052140L;
    private boolean enableTag = false;

    public boolean isEnableTag() {
        return this.enableTag;
    }

    public void setEnableTag(boolean enableTag) {
        this.enableTag = enableTag;
    }

    OssShipperJsonStorageDetail() {
        this.setStorageFormat("json");
    }

    @Override
    public JSONObject ToJsonObject() {
        JSONObject obj = new JSONObject();
        JSONObject storage = new JSONObject();
        JSONObject detail = new JSONObject();
        detail.put("enableTag", (Object)this.enableTag);
        storage.put("detail", (Object)detail);
        storage.put("format", (Object)this.getStorageFormat());
        obj.put("storage", (Object)storage);
        return obj;
    }

    @Override
    public void FromJsonObject(JSONObject storageDetail) throws LogException {
        this.setStorageFormat("json");
        if (!storageDetail.containsKey("storage")) {
            this.enableTag = false;
            return;
        }
        JSONObject storage = storageDetail.getJSONObject("storage");
        if (!storage.containsKey("detail")) {
            this.enableTag = false;
            return;
        }
        JSONObject detail = storage.getJSONObject("detail");
        if (!detail.containsKey("enableTag")) {
            this.enableTag = false;
            return;
        }
        try {
            this.setStorageFormat(storage.getString("format"));
            this.setEnableTag(detail.getBoolean("enableTag"));
        }
        catch (JSONException ex) {
            throw new LogException("FailToParseOssShipperJsonStorageDetail", ex.getMessage(), ex, "");
        }
    }
}

