/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.ShipperConfig;
import com.aliyun.openservices.log.exception.LogException;
import java.util.ArrayList;
import java.util.List;

public class OdpsShipperConfig
implements ShipperConfig {
    private String odpsEndPoint;
    private String odpsProject;
    private String odpsTable;
    private List<String> logFieldsList;
    private List<String> partitionColumn;
    private String partitionTimeFormat;
    private int bufferInterval;

    public OdpsShipperConfig(String odpsEndPoint, String odpsProject, String odpsTable, List<String> logFieldsList, List<String> partitionColumn, String partitionTimeFormat) {
        this.odpsEndPoint = odpsEndPoint;
        this.odpsProject = odpsProject;
        this.odpsTable = odpsTable;
        this.logFieldsList = logFieldsList;
        this.partitionColumn = partitionColumn;
        this.partitionTimeFormat = partitionTimeFormat;
        this.bufferInterval = 1800;
    }

    public OdpsShipperConfig() {
    }

    public String GetOdpsEndPoint() {
        return this.odpsEndPoint;
    }

    public String GetOdpsProject() {
        return this.odpsProject;
    }

    public String GetOdpsTable() {
        return this.odpsTable;
    }

    public List<String> GetLogFieldsList() {
        return new ArrayList<String>(this.logFieldsList);
    }

    public List<String> GetPartitionColumn() {
        return new ArrayList<String>(this.partitionColumn);
    }

    public String GetPartitionTimeFromat() {
        return this.partitionTimeFormat;
    }

    public int getBufferInterval() {
        return this.bufferInterval;
    }

    @Override
    public String GetShipperType() {
        return "odps";
    }

    public void setOdpsEndPoint(String odpsEndPoint) {
        this.odpsEndPoint = odpsEndPoint;
    }

    public void setOdpsProject(String odpsProject) {
        this.odpsProject = odpsProject;
    }

    public void setOdpsTable(String odpsTable) {
        this.odpsTable = odpsTable;
    }

    public void setLogFieldsList(List<String> logFieldsList) {
        this.logFieldsList = logFieldsList;
    }

    public void setPartitionColumn(List<String> partitionColumn) {
        this.partitionColumn = partitionColumn;
    }

    public void setPartitionTimeFormat(String partitionTimeFormat) {
        this.partitionTimeFormat = partitionTimeFormat;
    }

    public void setBufferInterval(int bufferInterval) {
        this.bufferInterval = bufferInterval;
    }

    @Override
    public JSONObject GetJsonObj() {
        JSONObject obj = new JSONObject();
        obj.put("odpsEndpoint", (Object)this.odpsEndPoint);
        obj.put("odpsProject", (Object)this.odpsProject);
        obj.put("odpsTable", (Object)this.odpsTable);
        obj.put("fields", (Object)this.logFieldsList);
        obj.put("partitionColumn", (Object)this.partitionColumn);
        obj.put("partitionTimeFormat", (Object)this.partitionTimeFormat);
        obj.put("bufferInterval", (Object)this.bufferInterval);
        return obj;
    }

    private List<String> FromJsonArray(JSONArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add(jsonArray.getString(i));
        }
        return list;
    }

    @Override
    public void FromJsonObj(JSONObject obj) throws LogException {
        try {
            this.odpsEndPoint = obj.getString("odpsEndpoint");
            this.odpsProject = obj.getString("odpsProject");
            this.odpsTable = obj.getString("odpsTable");
            this.logFieldsList = this.FromJsonArray(obj.getJSONArray("fields"));
            this.partitionColumn = this.FromJsonArray(obj.getJSONArray("partitionColumn"));
            this.partitionTimeFormat = obj.getString("partitionTimeFormat");
            this.bufferInterval = obj.getIntValue("bufferInterval");
        }
        catch (JSONException e) {
            throw new LogException("FailToParseOssShipperConfig", e.getMessage(), e, "");
        }
    }
}

