/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.Parameter;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;

public class ExternalStore
implements Serializable {
    private static final long serialVersionUID = 6493904490967634292L;
    private String externalStoreName;
    private String storeType;
    private Parameter parameter;

    public ExternalStore() {
    }

    public ExternalStore(String externalStoreName, String storeType, Parameter parameter) {
        this.externalStoreName = externalStoreName;
        this.storeType = storeType;
        this.parameter = parameter;
    }

    public ExternalStore(JSONObject object) throws LogException {
        this.fromJson(object);
    }

    public void fromJson(JSONObject object) throws LogException {
        try {
            this.setExternalStoreName(object.getString("externalStoreName"));
            this.setStoreType(object.getString("storeType"));
            this.setParameter(JSONObject.parseObject(object.getString("parameter"), Parameter.class));
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateExternalStore", e.getMessage(), e, "");
        }
    }

    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        object.put("externalStoreName", (Object)this.externalStoreName);
        object.put("storeType", (Object)this.storeType);
        object.put("parameter", (Object)this.parameter);
        return object;
    }

    public String getExternalStoreName() {
        return this.externalStoreName;
    }

    public void setExternalStoreName(String externalStoreName) {
        this.externalStoreName = externalStoreName;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public String toString() {
        return "ExternalStore{externalStoreName='" + this.externalStoreName + '\'' + ", storeType='" + this.storeType + '\'' + ", parameter=" + this.parameter + '}';
    }
}

