/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.DataSink;
import com.aliyun.openservices.log.common.DataSinkType;
import com.aliyun.openservices.log.util.JsonUtils;
import java.util.HashMap;
import java.util.Set;

public class AliyunADBSink
extends DataSink {
    private static final String ADB_V2 = "adb20";
    private static final String ADB_V3 = "adb30";
    private String url;
    private String user;
    private String password;
    private String dbType;
    private String regionId = "";
    private String zoneId = "";
    private String tableGroupName = "";
    private String vpcId = "";
    private String instanceId = "";
    private String instancePort = "";
    private String database;
    private String table;
    private int batchSize;
    private boolean strictMode;
    private HashMap<String, String> columnMapping;

    public AliyunADBSink() {
        super(DataSinkType.ALIYUN_ADB);
    }

    public void BuildAliyunADBV2Sink(String url, String user, String password, String regionId, String zoneId, String database, String tableGroupName, String table, int batchSize, boolean strictMode, HashMap<String, String> columnMapping) {
        this.dbType = ADB_V2;
        this.url = url;
        this.user = user;
        this.password = password;
        this.regionId = regionId;
        this.zoneId = zoneId;
        this.database = database;
        this.tableGroupName = tableGroupName;
        this.table = table;
        this.batchSize = batchSize;
        this.strictMode = strictMode;
        this.columnMapping = columnMapping;
    }

    public void BuildAliyunADBV3Sink(String url, String user, String password, String vpcId, String instanceId, String instancePort, String database, String table, int batchSize, boolean strictMode, HashMap<String, String> columnMapping) {
        this.dbType = ADB_V3;
        this.url = url;
        this.user = user;
        this.password = password;
        this.vpcId = vpcId;
        this.instanceId = instanceId;
        this.instancePort = instancePort;
        this.database = database;
        this.table = table;
        this.batchSize = batchSize;
        this.strictMode = strictMode;
        this.columnMapping = columnMapping;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public HashMap<String, String> getColumnMapping() {
        return this.columnMapping;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getTableGroupName() {
        return this.tableGroupName;
    }

    public void setTableGroupName(String tableGroupName) {
        this.tableGroupName = tableGroupName;
    }

    public void setColumnMapping(HashMap<String, String> columnMapping) {
        this.columnMapping = columnMapping;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstancePort() {
        return this.instancePort;
    }

    public void setInstancePort(String instancePort) {
        this.instancePort = instancePort;
    }

    @Override
    public void deserialize(JSONObject value) {
        this.url = value.getString("url");
        this.user = value.getString("user");
        this.password = value.getString("password");
        this.dbType = value.getString("dbType");
        if (this.dbType.equals(ADB_V2)) {
            this.regionId = value.getString("regionId");
            this.zoneId = value.getString("zoneId");
            this.tableGroupName = value.getString("tableGroupName");
            this.vpcId = JsonUtils.readOptionalString(value, "vpcId", "");
            this.instanceId = JsonUtils.readOptionalString(value, "instanceId", "");
            this.instancePort = JsonUtils.readOptionalString(value, "instancePort", "");
        } else {
            this.regionId = JsonUtils.readOptionalString(value, "regionId", "");
            this.zoneId = JsonUtils.readOptionalString(value, "zoneId", "");
            this.tableGroupName = JsonUtils.readOptionalString(value, "tableGroupName", "");
            this.vpcId = value.getString("vpcId");
            this.instanceId = value.getString("instanceId");
            this.instancePort = value.getString("instancePort");
        }
        this.database = value.getString("database");
        this.table = value.getString("table");
        this.batchSize = value.getIntValue("batchSize");
        this.strictMode = value.getBoolean("strictMode");
        JSONObject cm = value.getJSONObject("columnMapping");
        Set<String> keySet = cm.keySet();
        this.columnMapping = new HashMap();
        for (String key : keySet) {
            this.columnMapping.put(key, cm.getString(key));
        }
    }
}

