/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.selectdb.sink.writer;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import org.apache.seatunnel.connectors.selectdb.config.SelectDBConfig;

public class CopySQLBuilder {
    private static final String COPY_SYNC = "copy.async";
    private static final String COPY_DELETE = "copy.use_delete_sign";
    private final SelectDBConfig selectdbConfig;
    private final List<String> fileList;
    private Properties properties;

    public CopySQLBuilder(SelectDBConfig selectdbConfig, List<String> fileList) {
        this.selectdbConfig = selectdbConfig;
        this.fileList = fileList;
        this.properties = selectdbConfig.getStageLoadProps();
    }

    public String buildCopySQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("COPY INTO ").append(this.selectdbConfig.getTableIdentifier()).append(" FROM @~('{").append(String.join((CharSequence)",", this.fileList)).append("}') ").append("PROPERTIES (");
        this.properties.put(COPY_SYNC, (Object)false);
        if (this.selectdbConfig.getEnableDelete().booleanValue()) {
            this.properties.put(COPY_DELETE, (Object)true);
        }
        StringJoiner props = new StringJoiner(",");
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            String prop = String.format("'%s'='%s'", key, value);
            props.add(prop);
        }
        sb.append(props).append(")");
        return sb.toString();
    }
}

