/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.selectdb.sink;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EscapeHandler {
    public static final String ESCAPE_DELIMITERS_FLAGS = "\\x";
    public static final Pattern ESCAPE_PATTERN = Pattern.compile("\\\\x([0-9|a-f|A-F]{2})");
    public static final int RADIX = 16;

    public String escapeString(String source) {
        if (source.contains(ESCAPE_DELIMITERS_FLAGS)) {
            Matcher m = ESCAPE_PATTERN.matcher(source);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(buf, String.format("%s", Character.valueOf((char)Integer.parseInt(m.group(1), 16))));
            }
            m.appendTail(buf);
            return buf.toString();
        }
        return source;
    }

    public void handle(Properties properties) {
        String lineDelimiter;
        String fieldDelimiter = properties.getProperty("file.column_separator", "\t");
        if (fieldDelimiter.contains(ESCAPE_DELIMITERS_FLAGS)) {
            properties.setProperty("file.column_separator", this.escapeString(fieldDelimiter));
        }
        if ((lineDelimiter = properties.getProperty("file.line_delimiter", "\n")).contains(ESCAPE_DELIMITERS_FLAGS)) {
            properties.setProperty("file.line_delimiter", this.escapeString(lineDelimiter));
        }
    }

    public static void handleEscape(Properties properties) {
        EscapeHandler handler = new EscapeHandler();
        handler.handle(properties);
    }
}

