/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rocketmq.sink;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.selector.SelectMessageQueueByHash;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.common.RocketMqAdminUtil;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.common.RocketMqBaseConfiguration;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.exception.RocketMqConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.exception.RocketMqConnectorException;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.sink.RocketMqProducerSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMqNoTransactionSender
implements RocketMqProducerSender {
    private static final Logger log = LoggerFactory.getLogger(RocketMqNoTransactionSender.class);
    private final DefaultMQProducer rocketMqProducer;
    private final boolean isSync;

    public RocketMqNoTransactionSender(RocketMqBaseConfiguration configuration, boolean isSync) {
        this.isSync = isSync;
        this.rocketMqProducer = RocketMqAdminUtil.initDefaultMqProducer(configuration);
        try {
            this.rocketMqProducer.start();
        }
        catch (MQClientException e) {
            throw new RocketMqConnectorException((SeaTunnelErrorCode)RocketMqConnectorErrorCode.PRODUCER_START_ERROR, e);
        }
    }

    @Override
    public void send(Message message) {
        if (message == null) {
            return;
        }
        try {
            if (this.isSync) {
                if (StringUtils.isEmpty(message.getKeys())) {
                    this.rocketMqProducer.send(message);
                } else {
                    this.rocketMqProducer.send(message, new SelectMessageQueueByHash(), message.getKeys());
                }
            } else {
                SendCallback callback = new SendCallback(){

                    @Override
                    public void onSuccess(SendResult sendResult) {
                    }

                    @Override
                    public void onException(Throwable e) {
                        log.error("Failed to send data to rocketmq", e);
                    }
                };
                if (StringUtils.isEmpty(message.getKeys())) {
                    this.rocketMqProducer.send(message, callback);
                } else {
                    this.rocketMqProducer.send(message, (MessageQueueSelector)new SelectMessageQueueByHash(), (Object)message.getKeys(), callback);
                }
            }
        }
        catch (InterruptedException | MQBrokerException | MQClientException | RemotingException e) {
            throw new RocketMqConnectorException((SeaTunnelErrorCode)RocketMqConnectorErrorCode.PRODUCER_SEND_MESSAGE_ERROR, e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.rocketMqProducer != null) {
            this.rocketMqProducer.shutdown();
        }
    }
}

