/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.util;

import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisParameters;
import org.apache.seatunnel.connectors.seatunnel.redis.util.JsonKeyValueMerger;
import org.apache.seatunnel.connectors.seatunnel.redis.util.KeyValueMerger;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;

public class KeyValueMergerFactory {
    private KeyValueMergerFactory() {
    }

    public static KeyValueMerger createMerger(DeserializationSchema<?> schema, RedisParameters redisParameters) {
        if (schema == null) {
            throw CommonError.illegalArgument((String)"deserializationSchema is null", (String)"Redis source requires a deserialization schema to parse the record with key");
        }
        if (schema instanceof JsonDeserializationSchema) {
            return new JsonKeyValueMerger(redisParameters);
        }
        throw CommonError.unsupportedOperation((String)"Redis", (String)schema.getClass().getTypeName());
    }
}

