/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.util;

import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisParameters;
import org.apache.seatunnel.connectors.seatunnel.redis.util.KeyValueMerger;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonKeyValueMerger
implements KeyValueMerger {
    private static final Logger log = LoggerFactory.getLogger(JsonKeyValueMerger.class);
    private final RedisParameters redisParameters;

    public JsonKeyValueMerger(RedisParameters redisParameters) {
        this.redisParameters = redisParameters;
    }

    @Override
    public String parseWithKey(String key, String value) {
        ObjectNode objectNode = this.getObjectNode(key, value);
        return objectNode.toString();
    }

    private ObjectNode getObjectNode(String key, String value) {
        ObjectNode objectNode;
        String text;
        JsonNode node = JsonUtils.toJsonNode((Object)value);
        if (node.isTextual() && JsonKeyValueMerger.looksLikeJson(text = node.textValue())) {
            try {
                node = JsonUtils.parseObject((String)text);
            }
            catch (Exception e) {
                log.debug("Looks like JSON, but failed to parse JSON object from text value: {}", (Object)node.textValue());
            }
        }
        if (node instanceof ObjectNode) {
            objectNode = (ObjectNode)node;
        } else {
            objectNode = JsonUtils.createObjectNode();
            this.setValueInNode(objectNode, node);
        }
        objectNode.put(this.redisParameters.getKeyFieldName(), key);
        return objectNode;
    }

    public static boolean looksLikeJson(String text) {
        return text != null && (text.startsWith("{") && text.endsWith("}") || text.startsWith("[") && text.endsWith("]"));
    }

    private void setValueInNode(ObjectNode objectNode, JsonNode node) {
        String singleFieldName = this.redisParameters.getSingleFieldName();
        if (singleFieldName == null) {
            throw CommonError.illegalArgument((String)"singleFieldName is null", (String)"You must specify 'single_field_name' when using a single value with key-enabled schema.");
        }
        objectNode.set(singleFieldName, node);
    }
}

