/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.source;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.redis.client.RedisClient;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisParameters;
import org.apache.seatunnel.connectors.seatunnel.redis.source.RedisRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnKeyedRecordReader
extends RedisRecordReader {
    private static final Logger log = LoggerFactory.getLogger(UnKeyedRecordReader.class);

    public UnKeyedRecordReader(RedisParameters redisParameters, DeserializationSchema<SeaTunnelRow> deserializationSchema, RedisClient redisClient) {
        super(redisParameters, deserializationSchema, redisClient);
    }

    @Override
    public void pollZsetToNext(List<String> keys, Collector<SeaTunnelRow> output) throws IOException {
        List<List<String>> zSetList = this.redisClient.batchGetZset(keys);
        for (List<String> values : zSetList) {
            for (String value : values) {
                this.pollValueToNext(value, output);
            }
        }
    }

    @Override
    public void pollSetToNext(List<String> keys, Collector<SeaTunnelRow> output) throws IOException {
        List<Set<String>> setList = this.redisClient.batchGetSet(keys);
        for (Set<String> values : setList) {
            for (String value : values) {
                this.pollValueToNext(value, output);
            }
        }
    }

    @Override
    public void pollListToNext(List<String> keys, Collector<SeaTunnelRow> output) throws IOException {
        List<List<String>> valueList = this.redisClient.batchGetList(keys);
        for (List<String> values : valueList) {
            for (String value : values) {
                this.pollValueToNext(value, output);
            }
        }
    }

    @Override
    public void pollStringToNext(List<String> keys, Collector<SeaTunnelRow> output) throws IOException {
        List<String> values = this.redisClient.batchGetString(keys);
        for (String value : values) {
            this.pollValueToNext(value, output);
        }
    }

    private void pollValueToNext(String value, Collector<SeaTunnelRow> output) throws IOException {
        if (this.deserializationSchema == null) {
            output.collect((Object)new SeaTunnelRow(new Object[]{value}));
        } else {
            this.deserializationSchema.deserialize(value.getBytes(), output);
        }
    }
}

