/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.source;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.redis.client.RedisClient;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisParameters;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisSourceOptions;

public abstract class RedisRecordReader {
    protected final RedisParameters redisParameters;
    protected final DeserializationSchema<SeaTunnelRow> deserializationSchema;
    protected RedisClient redisClient;

    protected RedisRecordReader(RedisParameters redisParameters, DeserializationSchema<SeaTunnelRow> deserializationSchema, RedisClient redisClient) {
        this.redisParameters = redisParameters;
        this.deserializationSchema = deserializationSchema;
        this.redisClient = redisClient;
    }

    public void pollHashMapToNext(List<String> keys, Collector<SeaTunnelRow> output) throws IOException {
        List<Map<String, String>> values = this.redisClient.batchGetHash(keys);
        if (this.deserializationSchema == null) {
            for (Map<String, String> value : values) {
                output.collect((Object)new SeaTunnelRow(new Object[]{JsonUtils.toJsonString(value)}));
            }
            return;
        }
        for (Map<String, String> recordsMap : values) {
            if (this.redisParameters.getHashKeyParseMode() == RedisSourceOptions.HashKeyParseMode.KV) {
                this.deserializationSchema.deserialize(JsonUtils.toJsonString(recordsMap).getBytes(), output);
                continue;
            }
            SeaTunnelRow seaTunnelRow = new SeaTunnelRow(new Object[]{JsonUtils.toJsonString(recordsMap)});
            output.collect((Object)seaTunnelRow);
        }
    }

    public abstract void pollZsetToNext(List<String> var1, Collector<SeaTunnelRow> var2) throws IOException;

    public abstract void pollSetToNext(List<String> var1, Collector<SeaTunnelRow> var2) throws IOException;

    public abstract void pollListToNext(List<String> var1, Collector<SeaTunnelRow> var2) throws IOException;

    public abstract void pollStringToNext(List<String> var1, Collector<SeaTunnelRow> var2) throws IOException;
}

