/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.discoverer;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorException;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.discoverer.PulsarDiscoverer;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.topic.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicPatternDiscoverer
implements PulsarDiscoverer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(TopicPatternDiscoverer.class);
    private final Pattern topicPattern;
    private final RegexSubscriptionMode subscriptionMode;
    private final String namespace;

    public TopicPatternDiscoverer(Pattern topicPattern) {
        this.topicPattern = topicPattern;
        this.subscriptionMode = RegexSubscriptionMode.AllTopics;
        TopicName destination = TopicName.get(topicPattern.toString());
        NamespaceName namespaceName = destination.getNamespaceObject();
        this.namespace = namespaceName.toString();
    }

    @Override
    public Set<TopicPartition> getSubscribedTopicPartitions(PulsarAdmin pulsarAdmin) {
        LOG.debug("Fetching descriptions for all topics on pulsar cluster");
        try {
            return pulsarAdmin.namespaces().getTopics(this.namespace).parallelStream().filter(this::matchesSubscriptionMode).filter(topic -> this.topicPattern.matcher((CharSequence)topic).find()).map(topicName -> {
                String completeTopicName = TopicName.get(topicName).getPartitionedTopicName();
                try {
                    PartitionedTopicMetadata metadata = pulsarAdmin.topics().getPartitionedTopicMetadata(completeTopicName);
                    return PulsarDiscoverer.toTopicPartitions(topicName, metadata.partitions);
                }
                catch (PulsarAdminException e) {
                    throw new PulsarConnectorException((SeaTunnelErrorCode)PulsarConnectorErrorCode.GET_TOPIC_PARTITION_FAILED, e);
                }
            }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        catch (PulsarAdminException e) {
            throw new PulsarConnectorException((SeaTunnelErrorCode)PulsarConnectorErrorCode.GET_TOPIC_PARTITION_FAILED, e);
        }
    }

    private boolean matchesSubscriptionMode(String topic) {
        TopicName topicName = TopicName.get(topic);
        switch (this.subscriptionMode) {
            case PersistentOnly: {
                return topicName.isPersistent();
            }
            case NonPersistentOnly: {
                return !topicName.isPersistent();
            }
        }
        return true;
    }
}

