/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.stop;

import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorException;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.stop.StopCursor;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.topic.TopicPartition;

public class LatestMessageStopCursor
implements StopCursor {
    private static final long serialVersionUID = 1L;
    private MessageId messageId;

    public void prepare(PulsarAdmin admin, TopicPartition partition) {
        if (this.messageId == null) {
            String topic = partition.getFullTopicName();
            try {
                this.messageId = admin.topics().getLastMessageId(topic);
            }
            catch (PulsarAdminException e) {
                throw new PulsarConnectorException(PulsarConnectorErrorCode.GET_LAST_CURSOR_FAILED, "Failed to get the last cursor", e);
            }
        }
    }

    @Override
    public boolean shouldStop(Message<?> message) {
        MessageId id = message.getMessageId();
        return id.compareTo(this.messageId) >= 0;
    }

    @Override
    public StopCursor copy() {
        return new LatestMessageStopCursor();
    }
}

