/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.start;

import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.PulsarSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorException;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.start.StartCursor;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.topic.TopicPartition;

public class SubscriptionStartCursor
implements StartCursor {
    private static final long serialVersionUID = 1L;
    private final PulsarSourceOptions.CursorResetStrategy cursorResetStrategy;

    public SubscriptionStartCursor() {
        this.cursorResetStrategy = PulsarSourceOptions.CursorResetStrategy.LATEST;
    }

    public SubscriptionStartCursor(PulsarSourceOptions.CursorResetStrategy cursorResetStrategy) {
        this.cursorResetStrategy = cursorResetStrategy;
    }

    public void ensureSubscription(String subscription, TopicPartition partition, PulsarAdmin pulsarAdmin) {
        try {
            if (pulsarAdmin.topics().getSubscriptions(partition.getFullTopicName()).contains(subscription)) {
                return;
            }
            pulsarAdmin.topics().createSubscription(partition.getFullTopicName(), subscription, PulsarSourceOptions.CursorResetStrategy.EARLIEST == this.cursorResetStrategy ? MessageId.earliest : MessageId.latest);
        }
        catch (PulsarAdminException e) {
            throw new PulsarConnectorException((SeaTunnelErrorCode)PulsarConnectorErrorCode.OPEN_PULSAR_ADMIN_FAILED, e);
        }
    }

    @Override
    public void seekPosition(Consumer<?> consumer) throws PulsarClientException {
    }
}

