/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.source.split;

import com.mongodb.client.model.Filters;
import javax.annotation.Nullable;
import org.apache.seatunnel.connectors.seatunnel.mongodb.source.split.MongoSplit;
import org.bson.BsonDocument;

public class MongoSplitUtils {
    private static final String SPLIT_ID_TEMPLATE = "split-%d";

    public static MongoSplit createMongoSplit(int index, BsonDocument matchQuery, BsonDocument projection, String splitKey, @Nullable Object lowerBound, @Nullable Object upperBound) {
        return MongoSplitUtils.createMongoSplit(index, matchQuery, projection, splitKey, lowerBound, upperBound, 0L);
    }

    public static MongoSplit createMongoSplit(int index, BsonDocument matchQuery, BsonDocument projection, String splitKey, @Nullable Object lowerBound, @Nullable Object upperBound, long startOffset) {
        BsonDocument splitQuery = new BsonDocument();
        if (matchQuery != null) {
            matchQuery.forEach(splitQuery::append);
        }
        if (splitKey != null) {
            BsonDocument boundaryQuery = lowerBound != null && upperBound != null ? Filters.and(Filters.gte(splitKey, lowerBound), Filters.lt(splitKey, upperBound)).toBsonDocument() : (lowerBound != null ? Filters.gte(splitKey, lowerBound).toBsonDocument() : (upperBound != null ? Filters.lt(splitKey, upperBound).toBsonDocument() : new BsonDocument()));
            boundaryQuery.forEach(splitQuery::append);
        }
        return new MongoSplit(String.format(SPLIT_ID_TEMPLATE, index), splitQuery, projection, startOffset);
    }
}

