/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.sink;

import java.io.Serializable;

public class MongodbWriterOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String connectString;
    protected final String database;
    protected final String collection;
    protected final int flushSize;
    protected final long batchIntervalMs;
    protected final boolean upsertEnable;
    protected final String[] primaryKey;
    protected final int retryMax;
    protected final long retryInterval;
    protected final boolean transaction;

    public MongodbWriterOptions(String connectString, String database, String collection, int flushSize, long batchIntervalMs, boolean upsertEnable, String[] primaryKey, int retryMax, long retryInterval, boolean transaction) {
        this.connectString = connectString;
        this.database = database;
        this.collection = collection;
        this.flushSize = flushSize;
        this.batchIntervalMs = batchIntervalMs;
        this.upsertEnable = upsertEnable;
        this.primaryKey = primaryKey;
        this.retryMax = retryMax;
        this.retryInterval = retryInterval;
        this.transaction = transaction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getConnectString() {
        return this.connectString;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public int getFlushSize() {
        return this.flushSize;
    }

    public long getBatchIntervalMs() {
        return this.batchIntervalMs;
    }

    public boolean isUpsertEnable() {
        return this.upsertEnable;
    }

    public String[] getPrimaryKey() {
        return this.primaryKey;
    }

    public int getRetryMax() {
        return this.retryMax;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public boolean isTransaction() {
        return this.transaction;
    }

    public static class Builder {
        protected String connectString;
        protected String database;
        protected String collection;
        protected int flushSize;
        protected long batchIntervalMs;
        protected boolean upsertEnable;
        protected String[] primaryKey;
        protected int retryMax;
        protected long retryInterval;
        protected boolean transaction;

        public Builder withConnectString(String connectString) {
            this.connectString = connectString;
            return this;
        }

        public Builder withDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder withCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public Builder withFlushSize(int flushSize) {
            this.flushSize = flushSize;
            return this;
        }

        public Builder withBatchIntervalMs(Long batchIntervalMs) {
            this.batchIntervalMs = batchIntervalMs;
            return this;
        }

        public Builder withUpsertEnable(boolean upsertEnable) {
            this.upsertEnable = upsertEnable;
            return this;
        }

        public Builder withPrimaryKey(String[] primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public Builder withRetryMax(int retryMax) {
            this.retryMax = retryMax;
            return this;
        }

        public Builder withRetryInterval(Long retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public Builder withTransaction(boolean transaction) {
            this.transaction = transaction;
            return this;
        }

        public MongodbWriterOptions build() {
            return new MongodbWriterOptions(this.connectString, this.database, this.collection, this.flushSize, this.batchIntervalMs, this.upsertEnable, this.primaryKey, this.retryMax, this.retryInterval, this.transaction);
        }
    }
}

