/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import com.pingcap.tidb.tipb.ExprType;
import java.sql.Date;
import java.sql.Timestamp;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.tikv.common.ExtendedDateTime;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.InvalidCodecFormatException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.Converter;
import org.tikv.common.types.DataType;
import org.tikv.common.types.MySQLType;

public abstract class AbstractDateTimeType
extends DataType {
    AbstractDateTimeType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    AbstractDateTimeType(MySQLType tp) {
        super(tp);
    }

    public abstract DateTimeZone getTimezone();

    long decodeDateTime(int flag, CodecDataInput cdi) {
        ExtendedDateTime extendedDateTime;
        if (flag == 9) {
            extendedDateTime = Codec.DateTimeCodec.readFromUVarInt(cdi, this.getTimezone());
        } else if (flag == 4) {
            extendedDateTime = Codec.DateTimeCodec.readFromUInt(cdi, this.getTimezone());
        } else {
            throw new InvalidCodecFormatException("Invalid Flag type for " + this.getClass().getSimpleName() + ": " + flag);
        }
        if (extendedDateTime == null) {
            extendedDateTime = Codec.DateTimeCodec.createExtendedDateTime(this.getTimezone(), 1, 1, 1, 0, 0, 0, 0);
        }
        Timestamp ts = extendedDateTime.toTimeStamp();
        return ts.getTime() / 1000L * 1000000L + (long)(ts.getNanos() / 1000);
    }

    Timestamp decodeDateTimeForBatchWrite(int flag, CodecDataInput cdi) {
        ExtendedDateTime extendedDateTime;
        if (flag == 9) {
            extendedDateTime = Codec.DateTimeCodec.readFromUVarInt(cdi, this.getTimezone());
        } else if (flag == 4) {
            extendedDateTime = Codec.DateTimeCodec.readFromUInt(cdi, this.getTimezone());
        } else {
            throw new InvalidCodecFormatException("Invalid Flag type for " + this.getClass().getSimpleName() + ": " + flag);
        }
        if (extendedDateTime == null) {
            return Codec.DateTimeCodec.createExtendedDateTime(this.getTimezone(), 1, 1, 1, 0, 0, 0, 0).toTimeStamp();
        }
        return extendedDateTime.toTimeStamp();
    }

    LocalDate decodeDate(int flag, CodecDataInput cdi) {
        LocalDate date;
        if (flag == 9) {
            date = Codec.DateCodec.readFromUVarInt(cdi);
        } else if (flag == 4) {
            date = Codec.DateCodec.readFromUInt(cdi);
        } else {
            throw new InvalidCodecFormatException("Invalid Flag type for " + this.getClass().getSimpleName() + ": " + flag);
        }
        return date;
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        ExtendedDateTime edt = Converter.convertToDateTime(value);
        Codec.DateTimeCodec.writeDateTimeFully(cdo, edt, this.getTimezone());
    }

    @Override
    protected void encodeValue(CodecDataOutput cdo, Object value) {
        this.encodeKey(cdo, value);
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        ExtendedDateTime edt = Converter.convertToDateTime(value);
        Codec.DateTimeCodec.writeDateTimeProto(cdo, edt, this.getTimezone());
    }

    @Override
    public ExprType getProtoExprType() {
        return ExprType.MysqlTime;
    }

    Timestamp convertToMysqlDateTime(Object value) throws ConvertNotSupportException {
        Timestamp result;
        if (value instanceof String) {
            result = Timestamp.valueOf((String)value);
        } else if (value instanceof Date) {
            result = new Timestamp(((Date)value).getTime());
        } else if (value instanceof Timestamp) {
            result = (Timestamp)value;
        } else {
            throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
        }
        return result;
    }
}

